/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2Delta;
import com.pushtechnology.diffusion.datatype.recordv2.model.RecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConsumingRecordV2Topics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConsumingRecordV2Topics.class);
    private static final String ROOT_TOPIC = "FX";
    private final Map<String, Currency> currencies = new ConcurrentHashMap<String, Currency>();
    private Schema schema;
    private final RatesListener listener;
    private final Session session;

    public ClientConsumingRecordV2Topics(String serverUrl, RatesListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.session = Diffusion.sessions().principal("client").password("password").open(serverUrl);
        Topics topics = (Topics)this.session.feature(Topics.class);
        String topicSelector = String.format("?%s//", ROOT_TOPIC);
        topics.addStream(topicSelector, RecordV2.class, (Topics.ValueStream)new RatesValueStream());
        topics.subscribe(topicSelector).whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
    }

    public Rates getRates(String currency, String targetCurrency) {
        Currency currencyObject = this.currencies.get(currency);
        if (currencyObject != null) {
            return currencyObject.getRates(targetCurrency);
        }
        return null;
    }

    private void applyUpdate(String currency, String targetCurrency, RecordV2 oldValue, RecordV2 newValue) {
        Currency currencyObject = this.currencies.get(currency);
        if (currencyObject == null) {
            currencyObject = new Currency();
            this.currencies.put(currency, currencyObject);
        }
        if (this.schema == null) {
            this.updateWithoutSchema(currency, targetCurrency, oldValue, newValue, currencyObject);
        } else {
            this.updateWithSchema(currency, targetCurrency, oldValue, newValue, currencyObject);
        }
    }

    private void updateWithSchema(String currency, String targetCurrency, RecordV2 oldValue, RecordV2 newValue, Currency currencyObject) {
        RecordModel model = newValue.asModel(this.schema);
        String bid = model.get("Bid");
        String ask = model.get("Ask");
        currencyObject.setRate(targetCurrency, bid, ask);
        if (oldValue == null) {
            this.listener.onNewRate(currency, targetCurrency, bid, ask);
        } else {
            RecordV2Delta delta = newValue.diff(oldValue);
            for (RecordV2Delta.Change change : delta.changes(this.schema)) {
                String fieldName = change.fieldName();
                this.listener.onRateChange(currency, targetCurrency, fieldName, model.get(fieldName));
            }
        }
    }

    private void updateWithoutSchema(String currency, String targetCurrency, RecordV2 oldValue, RecordV2 newValue, Currency currencyObject) {
        List fields = newValue.asFields();
        String bid = (String)fields.get(0);
        String ask = (String)fields.get(1);
        currencyObject.setRate(targetCurrency, bid, ask);
        if (oldValue == null) {
            this.listener.onNewRate(currency, targetCurrency, bid, ask);
        } else {
            List oldfields = oldValue.asFields();
            String oldBid = (String)oldfields.get(0);
            String oldAsk = (String)oldfields.get(1);
            if (!bid.equals(oldBid)) {
                this.listener.onRateChange(currency, targetCurrency, "Bid", bid);
            }
            if (!ask.equals(oldAsk)) {
                this.listener.onRateChange(currency, targetCurrency, "Ask", ask);
            }
        }
    }

    private void removeCurrency(String currency) {
        Currency oldCurrency = this.currencies.remove(currency);
        for (String targetCurrency : oldCurrency.rates.keySet()) {
            this.listener.onRateRemoved(currency, targetCurrency);
        }
    }

    private void removeRate(String currency, String targetCurrency) {
        Currency currencyObject = this.currencies.get(currency);
        if (currencyObject != null && currencyObject.rates.remove(targetCurrency) != null) {
            this.listener.onRateRemoved(currency, targetCurrency);
        }
    }

    public void close() {
        this.currencies.clear();
        this.session.close();
    }

    private final class RatesValueStream
    extends Topics.ValueStream.Default<RecordV2> {
        private RatesValueStream() {
        }

        public void onSubscription(String topicPath, TopicSpecification specification) {
            String schemaString;
            boolean isRatesTopic = Diffusion.topicSelectors().parse("?FX/.*/.*").selects(topicPath);
            if (isRatesTopic && (schemaString = (String)specification.getProperties().get("SCHEMA")) != null && ClientConsumingRecordV2Topics.this.schema == null) {
                try {
                    ClientConsumingRecordV2Topics.this.schema = Diffusion.dataTypes().recordV2().parseSchema(schemaString);
                }
                catch (SchemaParseException e) {
                    LOG.error("Unable to parse recordV2 schema", (Throwable)e);
                }
            }
        }

        public void onValue(String topicPath, TopicSpecification specification, RecordV2 oldValue, RecordV2 newValue) {
            String[] topicElements = this.elements(topicPath);
            if (topicElements.length == 2) {
                ClientConsumingRecordV2Topics.this.applyUpdate(topicElements[0], topicElements[1], oldValue, newValue);
            }
        }

        public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
            String[] topicElements = this.elements(topicPath);
            if (topicElements.length == 2) {
                ClientConsumingRecordV2Topics.this.removeRate(topicElements[0], topicElements[1]);
            } else if (topicElements.length == 1) {
                ClientConsumingRecordV2Topics.this.removeCurrency(topicElements[0]);
            }
        }

        private String[] elements(String topicPath) {
            String subPath = topicPath.replaceFirst("^FX/", "");
            return subPath.split("/");
        }
    }

    public static interface RatesListener {
        public void onNewRate(String var1, String var2, String var3, String var4);

        public void onRateChange(String var1, String var2, String var3, String var4);

        public void onRateRemoved(String var1, String var2);
    }

    public static final class Rates {
        private final String bidRate;
        private final String askRate;

        private Rates(String bid, String ask) {
            this.bidRate = bid;
            this.askRate = ask;
        }

        public String getBidRate() {
            return this.bidRate;
        }

        public String getAskRate() {
            return this.askRate;
        }
    }

    private static class Currency {
        private final Map<String, Rates> rates = new HashMap<String, Rates>();

        private Currency() {
        }

        private Rates getRates(String currency) {
            return this.rates.get(currency);
        }

        private void setRate(String currency, String bid, String ask) {
            this.rates.put(currency, new Rates(bid, ask));
        }
    }
}

