/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.session.Session;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUsingSessionEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUsingSessionEventListener.class);
    private final Session session = Diffusion.sessions().principal("control").password("password").open("ws://localhost:8080");
    private final Registration registration;

    public ClientUsingSessionEventListener() throws Exception {
        ClientControl.SessionEventParameters parameters = Diffusion.newSessionEventParametersBuilder().properties(new String[]{"$Principal", "$COUNTRY "}).filter("$Principal NE 'admin'").after(Instant.now()).build();
        this.registration = (Registration)((ClientControl)this.session.feature(ClientControl.class)).addSessionEventListener((ClientControl.SessionEventStream)new MyEventStream(), parameters).get(5L, TimeUnit.SECONDS);
    }

    public void close() {
        this.registration.close();
        this.session.close();
    }

    class MyEventStream
    implements ClientControl.SessionEventStream {
        MyEventStream() {
        }

        public void onSessionEvent(ClientControl.SessionEventStream.Event event) {
            if (event.isOpenEvent()) {
                LOG.info("New session: id=%s", (Object)event.sessionId());
                return;
            }
            if (event.type() == ClientControl.SessionEventStream.Event.Type.STATE) {
                LOG.info("Session state changed: id=%s, state=%s", (Object)event.sessionId(), (Object)event.state());
            } else {
                LOG.info("Session properties changed: id=%s, properties=%s", (Object)event.sessionId(), (Object)event.changedProperties());
            }
        }

        public void onClose() {
            LOG.info("Stream closed");
        }

        public void onError(ErrorReason errorReason) {
            LOG.info("An error occured: %s", (Object)errorReason.getDescription());
        }
    }
}

