/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ControlClientAddingAndRemovingTopics {
    private final Session session;
    private final TopicControl topicControl;

    public ControlClientAddingAndRemovingTopics(String serverUrl) {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
    }

    public boolean addTopic(String topicPath, TopicType topicType) throws ExecutionException, TimeoutException, InterruptedException {
        return this.topicControl.addTopic(topicPath, topicType).get(5L, TimeUnit.SECONDS) == TopicControl.AddTopicResult.CREATED;
    }

    public void addTopic(String topicPath, TopicSpecification specification) throws InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, specification).get(5L, TimeUnit.SECONDS);
    }

    public boolean addSessionTopic(String topicPath, TopicType topicType) throws ExecutionException, TimeoutException, InterruptedException {
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)topicType).withProperty("REMOVAL", "when this session closes remove '?" + topicPath + "//'");
        return this.topicControl.addTopic(topicPath, specification).get(5L, TimeUnit.SECONDS) == TopicControl.AddTopicResult.CREATED;
    }

    public CompletableFuture<Integer> removeTopic(String topicPath) {
        return this.removeTopics(">" + topicPath);
    }

    public CompletableFuture<Integer> removeTopicBranch(String topicPath) {
        return this.removeTopics("?" + topicPath + "//");
    }

    public CompletableFuture<Integer> removeTopics(String topicSelector) {
        return this.topicControl.removeTopics(topicSelector).thenApply(TopicControl.TopicRemovalResult::getRemovedCount);
    }

    public void close() {
        this.session.close();
    }
}

