/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.clients.SecurityControl;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClientChangingSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientChangingSecurity.class);
    private final SecurityControl securityControl;
    private final SecurityControl.ScriptBuilder emptyScript;

    public ControlClientChangingSecurity() {
        Session session = Diffusion.sessions().principal("admin").password("password").open("wss://diffusion.example.com:80");
        this.securityControl = (SecurityControl)session.feature(SecurityControl.class);
        this.emptyScript = this.securityControl.scriptBuilder();
    }

    public CompletableFuture<Void> capitalizeRoles() {
        return this.securityControl.getSecurity().thenCompose(this::capitalizeRoles);
    }

    private CompletableFuture<Void> capitalizeRoles(SecurityControl.SecurityConfiguration configuration) {
        String script = this.emptyScript.setRolesForAnonymousSessions(ControlClientChangingSecurity.capitalizeSet(configuration.getRolesForAnonymousSessions())).setRolesForNamedSessions(ControlClientChangingSecurity.capitalizeSet(configuration.getRolesForNamedSessions())).append(configuration.getRoles().stream().map(this::capitalizeRole).reduce(this.emptyScript, (sb1, sb2) -> sb1.append(sb2))).script();
        LOG.info("Sending the following script to the server:\n{}", (Object)script);
        return this.securityControl.updateStore(script).thenAccept(ignored -> {});
    }

    private SecurityControl.ScriptBuilder capitalizeRole(SecurityControl.Role role) {
        Set oldIncludedRoles;
        String oldName = role.getName();
        String newName = ControlClientChangingSecurity.capitalizeString(oldName);
        SecurityControl.ScriptBuilder builder = this.emptyScript;
        if (!oldName.equals(newName)) {
            if (!role.getGlobalPermissions().isEmpty()) {
                builder = builder.setGlobalPermissions(oldName, Collections.emptySet()).setGlobalPermissions(newName, role.getGlobalPermissions());
            }
            if (!role.getDefaultPathPermissions().isEmpty()) {
                builder = builder.setDefaultPathPermissions(oldName, Collections.emptySet()).setDefaultPathPermissions(newName, role.getDefaultPathPermissions());
            }
            builder = builder.append(role.getPathPermissions().entrySet().stream().map(entry -> {
                String path = (String)entry.getKey();
                Set permissions = (Set)entry.getValue();
                return this.emptyScript.removePathPermissions(oldName, path).setPathPermissions(newName, path, permissions);
            }).reduce(this.emptyScript, (sb1, sb2) -> sb1.append(sb2)));
        }
        if ((oldIncludedRoles = role.getIncludedRoles()).isEmpty()) {
            return builder;
        }
        return builder.setRoleIncludes(oldName, Collections.emptySet()).setRoleIncludes(newName, ControlClientChangingSecurity.capitalizeSet(oldIncludedRoles));
    }

    private static Set<String> capitalizeSet(Set<String> roles) {
        return roles.stream().map(ControlClientChangingSecurity::capitalizeString).collect(Collectors.toCollection(TreeSet::new));
    }

    private static String capitalizeString(String role) {
        return Character.toUpperCase(role.charAt(0)) + role.substring(1);
    }

    public void close() {
        this.securityControl.getSession().close();
    }
}

