/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClientRequestHandling {
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientRequestHandling.class);
    private final Session session;
    private final Messaging messaging;

    public ControlClientRequestHandling(String serverURL) {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverURL);
        this.messaging = (Messaging)this.session.feature(Messaging.class);
    }

    public Registration addRequestHandler(String messagePath) throws InterruptedException, ExecutionException, TimeoutException {
        return (Registration)this.messaging.addRequestHandler(messagePath, JSON.class, JSON.class, (Messaging.RequestHandler)new JSONRequestHandler(), new String[0]).get(5L, TimeUnit.SECONDS);
    }

    public JSON sendRequest(SessionId sessionId, String messagePath, JSON request) throws InterruptedException, ExecutionException, TimeoutException {
        JSON response = (JSON)this.messaging.sendRequest(sessionId, messagePath, (Object)request, JSON.class, JSON.class).get(5L, TimeUnit.SECONDS);
        LOG.info("Response received: {}", (Object)response.toJsonString());
        return response;
    }

    public void close() {
        this.session.close();
    }

    public int sendRequestToFilter(String messagePath, JSON request, String filter) throws InterruptedException, ExecutionException, TimeoutException {
        int numberSent = (Integer)this.messaging.sendRequestToFilter(filter, messagePath, (Object)request, JSON.class, JSON.class, (Messaging.FilteredRequestCallback)new JSONFilterRequestCallback()).get(5L, TimeUnit.SECONDS);
        LOG.info("{} requests sent", (Object)numberSent);
        return numberSent;
    }

    private final class JSONFilterRequestCallback
    implements Messaging.FilteredRequestCallback<JSON> {
        private JSONFilterRequestCallback() {
        }

        public void onResponse(SessionId sessionId, JSON response) {
            LOG.info("Response received: {} from session {}", (Object)response.toJsonString(), (Object)sessionId);
        }

        public void onResponseError(SessionId sessionId, Throwable throwable) {
            LOG.info("Response error from session {} due to {}", (Object)sessionId, (Object)throwable);
        }
    }

    private final class JSONRequestHandler
    implements Messaging.RequestHandler<JSON, JSON> {
        private JSONRequestHandler() {
        }

        public void onClose() {
            LOG.info("JSONRequestHandler closed");
        }

        public void onError(ErrorReason errorReason) {
            LOG.info("JSONRequestHandler error: {}", (Object)errorReason);
        }

        public void onRequest(JSON request, Messaging.RequestHandler.RequestContext context, Messaging.RequestHandler.Responder<JSON> responder) {
            LOG.info("Handler received request: {} from session {}", (Object)request.toJsonString(), (Object)context.getSessionId());
            responder.respond((Object)request);
        }
    }
}

