/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientUsingTopicLifecycleProperties {
    private final Session session;
    private final TopicControl topicControl;
    private final TopicSpecification stringSpecification;

    public ControlClientUsingTopicLifecycleProperties(String serverUrl) throws Exception {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        this.stringSpecification = Diffusion.newTopicSpecification((TopicType)TopicType.STRING);
    }

    public void createTopicRemovedAfter(String topicPath, Date dateAndTime) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when time after " + dateAndTime.getTime())).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedAfter(String topicPath, String dateAndTime) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when time after '" + dateAndTime + "' remove '*" + topicPath + "//'")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenNoSubscriptions(String topicPath) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when subscriptions < 1 for 5m after 1h")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenNoUpdates(String topicPath) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when no updates for 5m after 1h")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenSessionCloses(String topicPath) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when this session closes")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenNoPrincipal(String topicPath, String principal) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when no session has '$Principal is \"" + principal + "\"' for 30m")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenNoAccountsSession(String topicPath) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when no session has 'Department is \"Accounts\"' for 1h after 1d")).get(5L, TimeUnit.SECONDS);
    }

    public void createTopicRemovedWhenTimeAfterAndNoSubscriptionsOrUpdates(String topicPath, String dateAndTime) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when time after '" + dateAndTime + "' and (subscriptions < 1 for 10m after 1h or no updates for 20m) ")).get(5L, TimeUnit.SECONDS);
    }

    public void createNonPersistentTopicRemovedAfter(String topicPath, Date dateAndTime) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("REMOVAL", "when time after " + dateAndTime.getTime()).withProperty("PERSISTENT", "false")).get(5L, TimeUnit.SECONDS);
    }

    public void createPrivateTopicBranch(String topicPath, String principal, String ... subTopics) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(topicPath, this.stringSpecification.withProperty("OWNER", "$Principal is '" + principal + "'").withProperty("REMOVAL", "when no session has '$Principal is \"" + principal + "\"' for 5m remove '*" + topicPath + "//'").withProperty("PERSISTENT", "false")).get(5L, TimeUnit.SECONDS);
        for (String subTopic : subTopics) {
            this.topicControl.addTopic(topicPath + "/" + subTopic, this.stringSpecification.withProperty("OWNER", "$Principal is '" + principal + "'").withProperty("PERSISTENT", "false")).get(5L, TimeUnit.SECONDS);
        }
    }

    public void close() {
        this.session.close();
    }
}

