/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.topics.views.TopicViews;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class CreateRemoteTopicView {
    private static final String ROOT_TOPIC = "Accounts";
    private final String primaryServerUrl;
    private final String secondaryServerUrl;

    public CreateRemoteTopicView(String primaryServerUrl, String secondaryServerUrl) {
        this.primaryServerUrl = primaryServerUrl;
        this.secondaryServerUrl = secondaryServerUrl;
    }

    private void addTopics(Session session) throws Exception {
        JSONDataType jsonDataType = Diffusion.dataTypes().json();
        JSON value = jsonDataType.fromJsonString("{\"foo\" : \"bar\" }");
        for (String type : Arrays.asList("Free", "Premium")) {
            for (int i = 0; i < 10; ++i) {
                ((TopicUpdate)session.feature(TopicUpdate.class)).addAndSet(String.format("%s/%s/%s-Account-%d", ROOT_TOPIC, type, type, i), Diffusion.newTopicSpecification((TopicType)TopicType.JSON), JSON.class, (Object)value).get(5L, TimeUnit.SECONDS);
            }
        }
    }

    private void createRemoteServer(Session session, String name) throws Exception {
        ((RemoteServers)session.feature(RemoteServers.class)).createRemoteServer((RemoteServers.RemoteServer)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)Diffusion.newRemoteServerBuilder(RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder.class)).principal("admin")).credentials(Diffusion.credentials().password("password"))).build(name, this.primaryServerUrl)).get(5L, TimeUnit.SECONDS);
    }

    private void createRemoteTopicView(Session session, String serverName, String viewName) throws Exception {
        String specification = String.format("map ?%s/%s// from %s to %s/<path(2)>", ROOT_TOPIC, "Premium", serverName, viewName);
        ((TopicViews)session.feature(TopicViews.class)).createTopicView(viewName, specification).get(5L, TimeUnit.SECONDS);
    }

    public void run() throws Exception {
        Session primarySession = Diffusion.sessions().principal("admin").password("password").open(this.primaryServerUrl);
        Session secondarySession = Diffusion.sessions().principal("admin").password("password").open(this.secondaryServerUrl);
        this.addTopics(primarySession);
        this.createRemoteServer(secondarySession, "foo");
        this.createRemoteTopicView(secondarySession, "foo", "bar");
        primarySession.close();
        secondarySession.close();
    }
}

