/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.views.TopicViews;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class CreateTopicView {
    private static final String ROOT_TOPIC = "Accounts";
    private static final JSON TOPIC_VALUE = Diffusion.dataTypes().json().fromJsonString("{\"foo\" : \"bar\" }");
    private static final TopicSpecification TOPIC_SPECIFICATION = Diffusion.newTopicSpecification((TopicType)TopicType.JSON);
    private final Session session;

    public CreateTopicView(String serverUrl) throws Exception {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
    }

    private void addTopics() throws Exception {
        for (String accountType : Arrays.asList("Free", "Premium")) {
            for (int i = 0; i < 10; ++i) {
                String topicPath = String.format("%s/%s/%s-Account-%d", ROOT_TOPIC, accountType, accountType, i);
                ((TopicUpdate)this.session.feature(TopicUpdate.class)).addAndSet(topicPath, TOPIC_SPECIFICATION, JSON.class, (Object)TOPIC_VALUE).get(5L, TimeUnit.SECONDS);
            }
        }
    }

    private void createTopicView() throws ExecutionException, InterruptedException, TimeoutException {
        String viewSpecification = "map ?Accounts/Premium// to Premium-Accounts-Only/<path(2)>";
        ((TopicViews)this.session.feature(TopicViews.class)).createTopicView("premium-view", "map ?Accounts/Premium// to Premium-Accounts-Only/<path(2)>").get(5L, TimeUnit.SECONDS);
    }

    public void run() throws Exception {
        this.addTopics();
        this.createTopicView();
        this.session.close();
    }
}

