/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClient.class);
    private final String url;
    private final String principal;
    private boolean running = false;
    private Session currentSession;
    private CountDownLatch waitForStoppedLatch;

    public AbstractClient(String url, String principal) {
        this.url = url;
        this.principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(String password) {
        AbstractClient abstractClient = this;
        synchronized (abstractClient) {
            if (this.running) {
                throw new IllegalStateException("Already running");
            }
            this.running = true;
            this.waitForStoppedLatch = new CountDownLatch(1);
        }
        Diffusion.sessions().principal(this.principal).password(password).listener(new Session.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSessionStateChanged(Session session, Session.State oldState, Session.State newState) {
                AbstractClient abstractClient = AbstractClient.this;
                synchronized (abstractClient) {
                    if (Session.State.CONNECTING == oldState && newState.isConnected()) {
                        AbstractClient.this.onStarted(session);
                    }
                    if (!oldState.isConnected() && newState.isConnected()) {
                        AbstractClient.this.currentSession = session;
                        AbstractClient.this.onConnected(session);
                    }
                    if (oldState.isConnected() && !newState.isConnected()) {
                        AbstractClient.this.onDisconnected();
                    }
                    if (newState.isClosed()) {
                        AbstractClient.this.waitForStoppedLatch.countDown();
                        AbstractClient.this.waitForStoppedLatch = null;
                        AbstractClient.this.running = false;
                    }
                }
            }
        }).open(this.url);
    }

    public final synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException("Not currently running");
        }
        this.currentSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForStopped() throws InterruptedException {
        CountDownLatch currentLatch;
        AbstractClient abstractClient = this;
        synchronized (abstractClient) {
            if (this.waitForStoppedLatch == null) {
                return;
            }
            currentLatch = this.waitForStoppedLatch;
        }
        currentLatch.await();
    }

    public void onStarted(Session session) {
        LOG.debug("Client started");
    }

    public void onConnected(Session session) {
        LOG.debug("Client connected");
    }

    public void onDisconnected() {
        LOG.debug("Client disconnected");
    }

    public void onError(ErrorReason errorReason) {
        LOG.error("Failed to start client: {}", (Object)errorReason);
    }
}

