/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.datatype.binary.Binary;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class RandomData {
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private static final Random RANDOM = new Random();
    private static final CBORFactory CBOR_FACTORY = new CBORFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)CBOR_FACTORY);
    private final int id;
    private final long timestamp;
    private final int randomInt;

    private RandomData(int id, long timestamp, int randomInt) {
        this.id = id;
        this.timestamp = timestamp;
        this.randomInt = randomInt;
    }

    public int getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getRandomInt() {
        return this.randomInt;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<id=" + this.id + ",timestamp=" + this.timestamp + ",randomInt=" + this.randomInt + '>';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RandomData next() {
        Class<RandomData> clazz = RandomData.class;
        synchronized (RandomData.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return new RandomData(ID_GENERATOR.getAndIncrement(), System.currentTimeMillis(), RANDOM.nextInt(Integer.MAX_VALUE));
        }
    }

    static Binary toBinary(RandomData randomData) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(randomData.getId());
        buffer.putLong(randomData.getTimestamp());
        buffer.putInt(randomData.getRandomInt());
        return Diffusion.dataTypes().binary().readValue(buffer.array());
    }

    static RandomData fromBinary(Binary binary) {
        ByteBuffer buffer = ByteBuffer.wrap(binary.toByteArray());
        int id = buffer.getInt();
        long timestamp = buffer.getLong();
        int randomInt = buffer.getInt();
        return new RandomData(id, timestamp, randomInt);
    }

    static JSON toJSON(RandomData randomData) throws JsonProcessingException {
        return Diffusion.dataTypes().json().readValue(OBJECT_MAPPER.writeValueAsBytes((Object)randomData));
    }
}

