/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConsumingSimpleTopics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConsumingSimpleTopics.class);
    private final Session session;

    public ClientConsumingSimpleTopics(String serverUrl, final StringListener stringListener) {
        this.session = Diffusion.sessions().principal("client").password("password").open(serverUrl);
        Topics topics = (Topics)this.session.feature(Topics.class);
        topics.addStream("StringTopic", String.class, (Topics.ValueStream)new Topics.ValueStream.Default<String>(){

            public void onValue(String topicPath, TopicSpecification specification, String oldValue, String newValue) {
                stringListener.onNewValue(topicPath, newValue);
            }
        });
        topics.subscribe("StringTopic").whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
    }

    public void close() {
        this.session.close();
    }

    public static interface StringListener {
        public void onNewValue(String var1, String var2);
    }
}

