/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUsingFetch {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUsingFetch.class);
    private final Session session;
    private final Topics topics;

    public ClientUsingFetch(String serverUrl) {
        this.session = Diffusion.sessions().principal("client").password("password").open(serverUrl);
        this.topics = (Topics)this.session.feature(Topics.class);
    }

    public List<Topics.FetchResult.TopicResult<Void>> fetchAll() throws InterruptedException, ExecutionException, TimeoutException {
        return ((Topics.FetchResult)this.topics.fetchRequest().fetch("*.*").get(5L, TimeUnit.SECONDS)).results();
    }

    public List<Topics.FetchResult.TopicResult<String>> fetchAllStringTopics(TopicSelector selector) throws InterruptedException, ExecutionException, TimeoutException {
        return ((Topics.FetchResult)this.topics.fetchRequest().withValues(String.class).fetch(selector).get(5L, TimeUnit.SECONDS)).results();
    }

    public Topics.FetchResult.TopicResult<String> fetchStringTopic(String topicPath) throws InterruptedException, ExecutionException, TimeoutException {
        return ((Topics.FetchResult)this.topics.fetchRequest().withValues(String.class).withProperties().fetch(topicPath).get(5L, TimeUnit.SECONDS)).results().stream().findFirst().orElse(null);
    }

    public String getStringTopicValue(String topicPath) throws InterruptedException, ExecutionException, TimeoutException {
        Topics.FetchResult.TopicResult<String> result = this.fetchStringTopic(topicPath);
        return result != null ? (String)result.value() : null;
    }

    public List<Topics.FetchResult.TopicResult<JSON>> fetchJSONTopics(TopicSelector selector) throws InterruptedException, ExecutionException, TimeoutException {
        return ((Topics.FetchResult)this.topics.fetchRequest().withValues(JSON.class).topicTypes(EnumSet.of(TopicType.JSON)).fetch(selector).get(5L, TimeUnit.SECONDS)).results();
    }

    public List<Topics.FetchResult.TopicResult<Bytes>> fetchRange(String from, String to) throws InterruptedException, ExecutionException, TimeoutException {
        return ((Topics.FetchResult)this.topics.fetchRequest().from(from).to(to).withValues(Bytes.class).fetch("*.*").get(5L, TimeUnit.SECONDS)).results();
    }

    public Topics.FetchResult<Bytes> next(String after, int limit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Topics.FetchResult)this.topics.fetchRequest().after(after).withValues(Bytes.class).first(limit).fetch("*.*").get(5L, TimeUnit.SECONDS);
    }

    public Topics.FetchResult<Bytes> prior(String before, int limit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Topics.FetchResult)this.topics.fetchRequest().before(before).withValues(Bytes.class).last(limit).fetch("*.*").get(5L, TimeUnit.SECONDS);
    }

    public Topics.FetchResult<Bytes> limitDeepBranches(String start, int limitTopLevel, int limitPerBranch) throws InterruptedException, ExecutionException, TimeoutException {
        return (Topics.FetchResult)this.topics.fetchRequest().withValues(Bytes.class).limitDeepBranches(limitTopLevel, limitPerBranch).fetch(start).get(5L, TimeUnit.SECONDS);
    }

    public void listAllStringTopics(int pageSize) throws InterruptedException, ExecutionException, TimeoutException {
        int page = 1;
        Topics.FetchResult result = (Topics.FetchResult)this.topics.fetchRequest().withValues(String.class).first(pageSize).fetch("*.*").get(5L, TimeUnit.SECONDS);
        while (ClientUsingFetch.logPage(page, (Topics.FetchResult<String>)result)) {
            result = (Topics.FetchResult)this.topics.fetchRequest().after(((Topics.FetchResult.TopicResult)result.results().get(pageSize - 1)).path()).withValues(String.class).first(pageSize).fetch("*.*").get(5L, TimeUnit.SECONDS);
            ++page;
        }
    }

    private static boolean logPage(int pageNumber, Topics.FetchResult<String> result) {
        List results = result.results();
        if (results.size() > 0) {
            LOG.info("Page {}", (Object)pageNumber);
            result.results().forEach(r -> LOG.info("{} = {}", (Object)r.path(), r.value()));
        }
        return result.hasMore();
    }

    public void close() {
        this.session.close();
    }
}

