/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.clients.ClientControl;
import com.pushtechnology.diffusion.client.features.control.topics.SubscriptionControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.SessionId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class ControlClientUsingSessionProperties {
    private final Session session = Diffusion.sessions().principal("control").password("password").open("ws://diffusion.example.com:80");
    private final ClientControl clientControl = (ClientControl)this.session.feature(ClientControl.class);
    private final SubscriptionControl subscriptionControl = (SubscriptionControl)this.session.feature(SubscriptionControl.class);
    private volatile String currentTopic = "ITAccounts";

    public ControlClientUsingSessionProperties() throws Exception {
        this.clientControl.setSessionPropertiesListener((ClientControl.SessionPropertiesStream)new ClientControl.SessionPropertiesStream.Default(){

            public void onSessionOpen(SessionId sessionId, Map<String, String> properties) {
                if ("Accounts".equals(properties.get("Department")) && "IT".equals(properties.get("$Country"))) {
                    ControlClientUsingSessionProperties.this.subscriptionControl.subscribe(sessionId, ControlClientUsingSessionProperties.this.currentTopic);
                }
            }
        }, new String[]{"$Country", "$Department"}).get(5L, TimeUnit.SECONDS);
    }

    public CompletableFuture<SubscriptionControl.SubscriptionByFilterResult> changeTopic(String newTopic) {
        String filter = "Department is 'Accounts' and $Country is 'IT'";
        String oldTopic = this.currentTopic;
        this.currentTopic = newTopic;
        return this.subscriptionControl.unsubscribeByFilter("Department is 'Accounts' and $Country is 'IT'", oldTopic).thenCompose(unsubscriptionResult -> this.subscriptionControl.subscribeByFilter("Department is 'Accounts' and $Country is 'IT'", this.currentTopic));
    }

    public void close() {
        this.session.close();
    }
}

