/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.website;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeSeriesExample {
    public void publish() throws ExecutionException, InterruptedException {
        Session session = Diffusion.sessions().principal("<PRINCIPAL>").password("<PASSWORD>").open("ws://<HOST>:<PORT>");
        TopicSpecification spec = Diffusion.newTopicSpecification((TopicType)TopicType.TIME_SERIES).withProperty("TIME_SERIES_EVENT_VALUE_TYPE", "int64");
        ((TopicControl)session.feature(TopicControl.class)).addTopic("<TOPIC_PATH>", spec).get();
        AtomicLong i = new AtomicLong(0L);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> ((TimeSeries)session.feature(TimeSeries.class)).append("<TOPIC_PATH>", Long.class, (Object)i.getAndIncrement(), Instant.now()), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void subscribe() throws ExecutionException, InterruptedException {
        Session session = Diffusion.sessions().principal("<PRINCIPAL>").password("<PASSWORD>").open("ws://<HOST>:<PORT>");
        ((Topics)session.feature(Topics.class)).addTimeSeriesStream("<TOPIC_PATH>", Long.class, (Topics.ValueStream)new Topics.ValueStream.Default<TimeSeries.Event<Long>>(){

            public void onValue(String topicPath, TopicSpecification specification, TimeSeries.Event<Long> oldValue, TimeSeries.Event<Long> newValue) {
                System.out.println("New time series value on: " + topicPath + ": " + newValue);
            }
        });
        ((Topics)session.feature(Topics.class)).subscribe("<TOPIC_PATH>").get();
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        TimeSeriesExample instance = new TimeSeriesExample();
        instance.subscribe();
        instance.publish();
    }
}

