/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.clients.SystemAuthenticationControl;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClientChangingSystemAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientChangingSystemAuthentication.class);
    private final SystemAuthenticationControl systemAuthenticationControl;
    private final SystemAuthenticationControl.ScriptBuilder emptyScript;

    public ControlClientChangingSystemAuthentication() {
        Session session = Diffusion.sessions().principal("admin").password("password").open("wss://diffusion.example.com:80");
        this.systemAuthenticationControl = (SystemAuthenticationControl)session.feature(SystemAuthenticationControl.class);
        this.emptyScript = this.systemAuthenticationControl.scriptBuilder();
    }

    public CompletableFuture<Void> changeSuperUsersToAdministrators() {
        return this.systemAuthenticationControl.getSystemAuthentication().thenCompose(configuration -> {
            String script = configuration.getPrincipals().stream().filter(p -> p.getAssignedRoles().contains("SUPERUSER")).map(p -> {
                HashSet<String> newRoles = new HashSet<String>(p.getAssignedRoles());
                newRoles.remove("SUPERUSER");
                newRoles.add("ADMINISTRATOR");
                return this.emptyScript.assignRoles(p.getName(), newRoles);
            }).reduce(this.emptyScript, (sb1, sb2) -> sb1.append(sb2)).script();
            LOG.info("Sending the following script to the server:\n{}", (Object)script);
            return this.systemAuthenticationControl.updateStore(script).thenAccept(ignored -> {});
        });
    }

    public void close() {
        this.systemAuthenticationControl.getSession().close();
    }
}

