/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClientUpdatingTimeSeriesTopics {
    private static final String TOPIC_PATH = "foo/timeseries";
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientUpdatingTimeSeriesTopics.class);
    private final Session session;
    private final TimeSeries timeSeries;
    private final TopicControl topicControl;

    public ControlClientUpdatingTimeSeriesTopics(String serverUrl) throws InterruptedException, ExecutionException, TimeoutException {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.timeSeries = (TimeSeries)this.session.feature(TimeSeries.class);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        TopicSpecification spec = Diffusion.newTopicSpecification((TopicType)TopicType.TIME_SERIES).withProperty("TIME_SERIES_EVENT_VALUE_TYPE", "int64");
        ((CompletableFuture)this.topicControl.addTopic(TOPIC_PATH, spec).thenAccept(result -> LOG.info("Add topic result: {}", result))).get(5L, TimeUnit.SECONDS);
    }

    public TimeSeries.EventMetadata appendValue(long value) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        return (TimeSeries.EventMetadata)this.timeSeries.append(TOPIC_PATH, Long.class, (Object)value).get(5L, TimeUnit.SECONDS);
    }

    public void close() throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.removeTopics("?foo//").get(5L, TimeUnit.SECONDS);
        this.session.close();
    }

    public void editLast(long value) {
        this.timeSeries.rangeQuery().fromLast(1L).as(Long.class).selectFrom(TOPIC_PATH).whenComplete((query, ex) -> {
            if (ex != null) {
                LOG.error("Error obtaining the range query: {}", ex);
                return;
            }
            query.stream().forEach(event -> this.timeSeries.edit(TOPIC_PATH, event.sequence(), Long.class, (Object)value).whenComplete((metadata, e) -> {
                if (e != null) {
                    LOG.error("Error editing topic: {}", e);
                    return;
                }
                LOG.info("EventMetadata from edit: {}", metadata);
            }));
        });
    }

    public TimeSeries.EventMetadata appendValue(long value, Instant timestamp) throws IllegalArgumentException, InterruptedException, ExecutionException, TimeoutException {
        return (TimeSeries.EventMetadata)this.timeSeries.append(TOPIC_PATH, Long.class, (Object)value, timestamp).get(5L, TimeUnit.SECONDS);
    }
}

