/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.features.control.topics.SubscriptionControl;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClientSubscriptionControlRouting {
    private static final Logger LOG = LoggerFactory.getLogger(ControlClientSubscriptionControlRouting.class);
    private final Session session;
    private final SubscriptionControl subscriptionControl;

    public ControlClientSubscriptionControlRouting(String serverUrl) {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.subscriptionControl = (SubscriptionControl)this.session.feature(SubscriptionControl.class);
    }

    public CompletableFuture<Registration> addRoute(String topic, final String sourceTopic) {
        return this.subscriptionControl.addRoutingSubscriptionHandler(topic, (SubscriptionControl.RoutingSubscriptionRequest.RoutingHandler)new SubscriptionControl.RoutingSubscriptionRequest.RoutingHandler.Default(){

            public void onSubscriptionRequest(SubscriptionControl.RoutingSubscriptionRequest request) {
                request.route(sourceTopic).whenComplete((voidResult, exception) -> {
                    if (exception != null) {
                        LOG.info("subscription routing failed", exception);
                    }
                });
            }
        });
    }

    public void close() {
        this.session.close();
    }
}

