/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteServersFeature {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteServersFeature.class);
    private Session session;

    public void createRemoteServer() throws Exception {
        RemoteServers.SecondaryInitiator secondaryInitiator = (RemoteServers.SecondaryInitiator)((RemoteServers)this.session.feature(RemoteServers.class)).createRemoteServer((RemoteServers.RemoteServer)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)((RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder)Diffusion.newRemoteServerBuilder(RemoteServers.SecondaryInitiator.SecondaryInitiatorBuilder.class)).principal("admin")).credentials(Diffusion.credentials().password("password"))).build("Server_1", "ws://remote_server:80")).get(5L, TimeUnit.SECONDS);
        RemoteServers.PrimaryInitiator primaryInitiator = (RemoteServers.PrimaryInitiator)((RemoteServers)this.session.feature(RemoteServers.class)).createRemoteServer((RemoteServers.RemoteServer)((RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder)Diffusion.newRemoteServerBuilder(RemoteServers.PrimaryInitiator.PrimaryInitiatorBuilder.class)).retryDelay(5000).build("Server_1", Arrays.asList("ws://secondary_server1:80", "ws://secondary_server2:80"), "PrimaryConnector")).get(5L, TimeUnit.SECONDS);
        RemoteServers.SecondaryAcceptor secondaryAcceptor = (RemoteServers.SecondaryAcceptor)((RemoteServers)this.session.feature(RemoteServers.class)).createRemoteServer((RemoteServers.RemoteServer)((RemoteServers.SecondaryAcceptor.SecondaryAcceptorBuilder)((RemoteServers.SecondaryAcceptor.SecondaryAcceptorBuilder)((RemoteServers.SecondaryAcceptor.SecondaryAcceptorBuilder)Diffusion.newRemoteServerBuilder(RemoteServers.SecondaryAcceptor.SecondaryAcceptorBuilder.class)).principal("admin")).credentials(Diffusion.credentials().password("password"))).build("Server_1", "PrimaryHost")).get(5L, TimeUnit.SECONDS);
    }

    public void checkRemoteServer() throws Exception {
        RemoteServers.CheckRemoteServerResult result = (RemoteServers.CheckRemoteServerResult)((RemoteServers)this.session.feature(RemoteServers.class)).checkRemoteServer("Server_1").get(5L, TimeUnit.SECONDS);
        switch (result.getConnectionState()) {
            case CONNECTED: {
                LOG.info("Fully connected");
                break;
            }
            case FAILED: {
                LOG.info("Failed with " + result.getFailureMessage());
                break;
            }
            case INACTIVE: {
                LOG.info("Inactive");
                break;
            }
            case MISSING: {
                LOG.info("No such remote server");
                break;
            }
            case RETRYING: {
                LOG.info("Failed with " + result.getFailureMessage() + " but retry is scheduled");
                break;
            }
        }
    }

    public void listRemoteServers() throws Exception {
        List servers = (List)((RemoteServers)this.session.feature(RemoteServers.class)).listRemoteServers().get(5L, TimeUnit.SECONDS);
        for (RemoteServers.RemoteServer remoteServer : servers) {
            switch (remoteServer.getType()) {
                case PRIMARY_INITIATOR: {
                    RemoteServers.PrimaryInitiator pi = (RemoteServers.PrimaryInitiator)remoteServer;
                    LOG.info("Primary Initiator " + pi.getName() + " - Connecting to " + pi.getUrls() + " using connector " + pi.getConnector());
                    break;
                }
                case SECONDARY_ACCEPTOR: {
                    RemoteServers.SecondaryAcceptor sa = (RemoteServers.SecondaryAcceptor)remoteServer;
                    LOG.info("Secondary Acceptor " + sa.getName() + " - Connecting to " + sa.getPrimaryHostName());
                    break;
                }
                case SECONDARY_INITIATOR: {
                    RemoteServers.SecondaryInitiator si = (RemoteServers.SecondaryInitiator)remoteServer;
                    LOG.info("Secondary Initiator " + si.getName() + " - Connecting to " + si.getUrl());
                    break;
                }
            }
        }
    }

    public void removeRemoteServer() throws Exception {
        ((RemoteServers)this.session.feature(RemoteServers.class)).removeRemoteServer("Server_1").get(5L, TimeUnit.SECONDS);
    }
}

