/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.features.Callback;
import com.pushtechnology.diffusion.client.features.ContextCallback;
import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.SessionTrees;
import com.pushtechnology.diffusion.client.features.control.topics.views.TopicViews;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Topics
extends TopicUpdate,
TopicViews,
SessionTrees {
    public <V> void addStream(TopicSelector var1, Class<? extends V> var2, ValueStream<V> var3) throws IllegalArgumentException;

    public <V> void addStream(String var1, Class<? extends V> var2, ValueStream<V> var3) throws IllegalArgumentException;

    public <V> void addFallbackStream(Class<? extends V> var1, ValueStream<V> var2) throws IllegalArgumentException;

    public <V> void addTimeSeriesStream(TopicSelector var1, Class<? extends V> var2, ValueStream<TimeSeries.Event<V>> var3) throws IllegalArgumentException;

    public <V> void addTimeSeriesStream(String var1, Class<? extends V> var2, ValueStream<TimeSeries.Event<V>> var3) throws IllegalArgumentException;

    public void removeStream(Stream var1);

    public CompletableFuture<?> subscribe(TopicSelector var1);

    public CompletableFuture<?> subscribe(String var1);

    public CompletableFuture<?> unsubscribe(TopicSelector var1);

    public CompletableFuture<?> unsubscribe(String var1);

    @Deprecated
    public void subscribe(TopicSelector var1, CompletionCallback var2);

    @Deprecated
    public void subscribe(String var1, CompletionCallback var2) throws IllegalArgumentException;

    @Deprecated
    public <C> void subscribe(TopicSelector var1, C var2, CompletionContextCallback<C> var3);

    @Deprecated
    public <C> void subscribe(String var1, C var2, CompletionContextCallback<C> var3) throws IllegalArgumentException;

    @Deprecated
    public void unsubscribe(TopicSelector var1, CompletionCallback var2);

    @Deprecated
    public void unsubscribe(String var1, CompletionCallback var2) throws IllegalArgumentException;

    @Deprecated
    public <C> void unsubscribe(TopicSelector var1, C var2, CompletionContextCallback<C> var3);

    @Deprecated
    public <C> void unsubscribe(String var1, C var2, CompletionContextCallback<C> var3) throws IllegalArgumentException;

    public FetchRequest<Void> fetchRequest();

    public static interface FetchResult<V> {
        public List<TopicResult<V>> results();

        public boolean hasMore();

        public int size();

        public boolean isEmpty();

        public static interface TopicResult<V> {
            public String path();

            public TopicType type();

            public V value();

            public TopicSpecification specification();

            public int valueSize();

            public int valueCount();

            public long valueTotalSize();
        }
    }

    public static interface FetchRequest<V> {
        public static final Set<TopicType> ALL_TYPES = Collections.unmodifiableSet(EnumSet.of(TopicType.JSON, new TopicType[]{TopicType.BINARY, TopicType.RECORD_V2, TopicType.DOUBLE, TopicType.INT64, TopicType.STRING, TopicType.TIME_SERIES}));

        public FetchRequest<V> from(String var1);

        public FetchRequest<V> after(String var1);

        public FetchRequest<V> to(String var1);

        public FetchRequest<V> before(String var1);

        public FetchRequest<V> topicTypes(Set<TopicType> var1);

        public <T> FetchRequest<T> withValues(Class<? extends T> var1);

        public FetchRequest<V> withSizes();

        public FetchRequest<V> withProperties();

        public FetchRequest<V> withUnpublishedDelayedTopics();

        public FetchRequest<V> first(int var1);

        public FetchRequest<V> last(int var1);

        public FetchRequest<V> maximumResultSize(int var1);

        public FetchRequest<V> limitDeepBranches(int var1, int var2);

        public CompletableFuture<FetchResult<V>> fetch(TopicSelector var1);

        public CompletableFuture<FetchResult<V>> fetch(String var1);
    }

    public static enum UnsubscribeReason {
        REQUESTED,
        CONTROL,
        REMOVAL,
        AUTHORIZATION,
        SUBSCRIPTION_REFRESH,
        STREAM_CHANGE,
        BACK_PRESSURE,
        BRANCH_MAPPINGS,
        UNKNOWN_UNSUBSCRIBE_REASON;

    }

    public static interface ValueStream<V>
    extends SubscriberStream {
        public void onValue(String var1, TopicSpecification var2, V var3, V var4);

        public static class Default<V>
        extends SubscriberStream.Default
        implements ValueStream<V> {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onValue(String topicPath, TopicSpecification specification, V oldValue, V newValue) {
                LOG.debug("{} - Value received for topic {} : {} {}", new Object[]{this, topicPath, oldValue, newValue});
            }
        }
    }

    public static interface SubscriberStream
    extends Stream {
        public void onSubscription(String var1, TopicSpecification var2);

        public void onUnsubscription(String var1, TopicSpecification var2, UnsubscribeReason var3);

        public static abstract class Default
        extends Stream.Default
        implements SubscriberStream {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onSubscription(String topicPath, TopicSpecification specification) {
                LOG.debug("{} - Topic {} subscribed : {}", new Object[]{this, topicPath, specification});
            }

            @Override
            public void onUnsubscription(String topicPath, TopicSpecification specification, UnsubscribeReason reason) {
                LOG.debug("{} - Topic {} unsubscribed : {}", new Object[]{this, topicPath, reason});
            }
        }
    }

    @Deprecated
    public static interface CompletionContextCallback<C>
    extends ContextCallback<C> {
        public void onComplete(C var1);

        public static class Default<C>
        extends ContextCallback.Default<C>
        implements CompletionContextCallback<C> {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onComplete(C context) {
                LOG.debug("{} - Completed subscribe/unsubscribe, context={}", (Object)this, context);
            }
        }
    }

    @Deprecated
    public static interface CompletionCallback
    extends Callback {
        public void onComplete();

        public static class Default
        extends Callback.Default
        implements CompletionCallback {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onComplete() {
                LOG.debug("{} - Completed subscribe/unsubscribe", (Object)this);
            }
        }
    }
}

