/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Messaging
extends Feature {
    public <T, R> CompletableFuture<R> sendRequest(String var1, T var2, Class<T> var3, Class<R> var4);

    public <T, R> RequestStream<?, ?> setRequestStream(String var1, Class<? extends T> var2, Class<? super R> var3, RequestStream<T, R> var4);

    public RequestStream<?, ?> removeRequestStream(String var1);

    public <T, R> CompletableFuture<R> sendRequest(SessionId var1, String var2, T var3, Class<T> var4, Class<R> var5);

    public <T, R> CompletableFuture<Registration> addRequestHandler(String var1, Class<? extends T> var2, Class<? super R> var3, RequestHandler<T, R> var4, String ... var5);

    public <T, R> CompletableFuture<Integer> sendRequestToFilter(String var1, String var2, T var3, Class<T> var4, Class<R> var5, FilteredRequestCallback<? super R> var6);

    public static interface RequestHandler<T, R>
    extends Stream {
        public void onRequest(T var1, RequestContext var2, Responder<R> var3);

        public static interface Responder<R> {
            public void respond(R var1);

            public void reject(String var1);
        }

        public static interface RequestContext {
            public SessionId getSessionId();

            public String getPath();

            public Map<String, String> getSessionProperties();
        }
    }

    public static interface FilteredRequestCallback<R> {
        public void onResponse(SessionId var1, R var2);

        public void onResponseError(SessionId var1, Throwable var2);

        public static class Default<R>
        extends Stream.Default
        implements FilteredRequestCallback<R> {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onResponse(SessionId sessionId, R response) {
                LOG.debug("Response received: {} from session {}", response, (Object)sessionId);
            }

            @Override
            public void onResponseError(SessionId sessionId, Throwable throwable) {
                LOG.warn("Error on response from session {}", (Object)sessionId, (Object)throwable);
            }
        }
    }

    public static interface RequestStream<T, R>
    extends Stream {
        public void onRequest(String var1, T var2, Responder<R> var3);

        public static interface Responder<R> {
            public void respond(R var1);

            public void reject(String var1);
        }
    }
}

