/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.clients;

import com.pushtechnology.diffusion.client.callbacks.Callback;
import com.pushtechnology.diffusion.client.callbacks.ContextCallback;
import com.pushtechnology.diffusion.client.features.control.clients.SecurityStoreFeature;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface SystemAuthenticationControl
extends SecurityStoreFeature {
    public CompletableFuture<SystemAuthenticationConfiguration> getSystemAuthentication();

    @Deprecated
    public void getSystemAuthentication(ConfigurationCallback var1);

    @Deprecated
    public <C> void getSystemAuthentication(C var1, ConfigurationContextCallback<C> var2);

    public ScriptBuilder scriptBuilder();

    public static interface ScriptBuilder {
        public ScriptBuilder addPrincipal(String var1, String var2, Set<String> var3);

        public ScriptBuilder addPrincipal(String var1, String var2, Set<String> var3, String var4);

        public ScriptBuilder setPassword(String var1, String var2);

        public ScriptBuilder verifyPassword(String var1, String var2);

        public ScriptBuilder assignRoles(String var1, Set<String> var2);

        public ScriptBuilder removePrincipal(String var1);

        public ScriptBuilder allowAnonymousConnections(Set<String> var1);

        public ScriptBuilder denyAnonymousConnections();

        public ScriptBuilder abstainAnonymousConnections();

        public ScriptBuilder trustClientProposedPropertyIn(String var1, Set<String> var2);

        public ScriptBuilder trustClientProposedPropertyMatches(String var1, String var2);

        public ScriptBuilder ignoreClientProposedProperty(String var1);

        public ScriptBuilder append(ScriptBuilder var1);

        public String script();
    }

    public static interface SessionPropertyValidation {

        public static interface MatchesSessionPropertyValidation
        extends SessionPropertyValidation {
            public String getRegex();
        }

        public static interface ValuesSessionPropertyValidation
        extends SessionPropertyValidation {
            public Set<String> getValues();
        }
    }

    public static interface SystemPrincipal {
        public String getName();

        public Set<String> getAssignedRoles();

        public Optional<String> getLockingPrincipal();
    }

    public static interface SystemAuthenticationConfiguration {
        public Collection<SystemPrincipal> getPrincipals();

        public AnonymousConnectionAction getAnonymousAction();

        public Set<String> getRolesForAnonymousSessions();

        public Map<String, SessionPropertyValidation> getTrustedClientProposedProperties();
    }

    public static enum AnonymousConnectionAction {
        ALLOW,
        DENY,
        ABSTAIN;

    }

    @Deprecated
    public static interface ConfigurationContextCallback<C>
    extends ContextCallback<C> {
        public void onReply(C var1, SystemAuthenticationConfiguration var2);
    }

    @Deprecated
    public static interface ConfigurationCallback
    extends Callback {
        public void onReply(SystemAuthenticationConfiguration var1);
    }
}

