/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control;

import com.pushtechnology.diffusion.client.features.ErrorReportsException;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface RemoteServers
extends Feature {
    public CompletableFuture<RemoteServer> createRemoteServer(RemoteServer var1);

    public CompletableFuture<List<RemoteServer>> listRemoteServers();

    public CompletableFuture<CheckRemoteServerResult> checkRemoteServer(String var1);

    public CompletableFuture<Void> removeRemoteServer(String var1);

    public static final class RemoteServerOptionsException
    extends ErrorReportsException {
        private static final long serialVersionUID = 6069777787663040691L;

        public RemoteServerOptionsException(String message, List<ErrorReport> reports) {
            super(message, reports);
        }
    }

    public static final class RemoteServerExistsException
    extends SessionException {
        private static final long serialVersionUID = 4675880972876068202L;

        public RemoteServerExistsException(String message) {
            super(message);
        }
    }

    public static interface CheckRemoteServerResult {
        public ConnectionState getConnectionState();

        public String getFailureMessage();

        public static enum ConnectionState {
            INACTIVE,
            CONNECTED,
            RETRYING,
            FAILED,
            MISSING;

        }
    }

    public static interface SecondaryAcceptor
    extends SecondaryServer {
        public String getPrimaryHostName();

        public static interface SecondaryAcceptorBuilder
        extends SecondaryServer.SecondaryBuilder<SecondaryAcceptorBuilder> {
            public SecondaryAcceptor build(String var1, String var2);
        }
    }

    public static interface SecondaryInitiator
    extends SecondaryServer {
        @Override
        public String getUrl();

        public static interface SecondaryInitiatorBuilder
        extends SecondaryServer.SecondaryBuilder<SecondaryInitiatorBuilder> {
            public SecondaryInitiator build(String var1, String var2);
        }
    }

    public static interface SecondaryServer
    extends RemoteServer {
        @Override
        public String getPrincipal();

        @Override
        public Map<RemoteServer.ConnectionOption, String> getConnectionOptions();

        @Override
        public String getMissingTopicNotificationFilter();

        public static interface SecondaryBuilder<B>
        extends RemoteServer.RemoteServerBuilder<B> {
            public B principal(String var1);

            public B credentials(Credentials var1);

            public B connectionOptions(Map<RemoteServer.ConnectionOption, String> var1);

            public B connectionOption(RemoteServer.ConnectionOption var1, String var2);

            public B missingTopicNotificationFilter(String var1);
        }
    }

    public static interface PrimaryInitiator
    extends RemoteServer {
        public List<String> getUrls();

        public String getConnector();

        public int getRetryDelay();

        public static interface PrimaryInitiatorBuilder
        extends RemoteServer.RemoteServerBuilder<PrimaryInitiatorBuilder> {
            public PrimaryInitiatorBuilder retryDelay(int var1);

            public PrimaryInitiator build(String var1, List<String> var2, String var3);
        }
    }

    public static interface RemoteServer {
        public Type getType();

        public String getName();

        @Deprecated
        public String getUrl();

        @Deprecated
        public String getPrincipal();

        @Deprecated
        public Map<ConnectionOption, String> getConnectionOptions();

        @Deprecated
        public String getMissingTopicNotificationFilter();

        public static enum ConnectionOption {
            RECONNECTION_TIMEOUT,
            RETRY_DELAY,
            RECOVERY_BUFFER_SIZE,
            INPUT_BUFFER_SIZE,
            OUTPUT_BUFFER_SIZE,
            MAXIMUM_QUEUE_SIZE,
            CONNECTION_TIMEOUT,
            WRITE_TIMEOUT;

        }

        @Deprecated
        public static interface Builder {
            public Builder principal(String var1);

            public Builder credentials(Credentials var1);

            public Builder connectionOptions(Map<ConnectionOption, String> var1);

            public Builder connectionOption(ConnectionOption var1, String var2);

            public Builder missingTopicNotificationFilter(String var1);

            public Builder reset();

            public RemoteServer create(String var1, String var2);
        }

        public static interface RemoteServerBuilder<B> {
            public B reset();
        }

        public static enum Type {
            SECONDARY_INITIATOR,
            PRIMARY_INITIATOR,
            SECONDARY_ACCEPTOR;

        }
    }
}

