/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.topics;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.topics.TopicSelector;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface TopicControl
extends Feature {
    public CompletableFuture<AddTopicResult> addTopic(String var1, TopicType var2);

    public CompletableFuture<AddTopicResult> addTopic(String var1, TopicSpecification var2);

    public CompletableFuture<TopicRemovalResult> removeTopics(TopicSelector var1);

    public CompletableFuture<TopicRemovalResult> removeTopics(String var1) throws IllegalArgumentException;

    public CompletableFuture<Registration> addMissingTopicHandler(String var1, MissingTopicNotificationStream var2);

    public static final class IncompatibleExistingTopicException
    extends IncompatibleTopicException {
        private static final long serialVersionUID = 5075815951750161358L;

        public IncompatibleExistingTopicException(String message) {
            super(message);
        }
    }

    public static abstract class IncompatibleTopicException
    extends AddTopicException {
        private static final long serialVersionUID = 8083381286283811102L;

        public IncompatibleTopicException(String message) {
            super(message);
        }
    }

    public static final class TopicLicenseLimitException
    extends AddTopicException {
        private static final long serialVersionUID = 3459583462376598320L;

        public TopicLicenseLimitException(String message) {
            super(message);
        }
    }

    public static final class InvalidTopicPathException
    extends AddTopicException {
        private static final long serialVersionUID = -132560805100117118L;

        public InvalidTopicPathException(String message) {
            super(message);
        }
    }

    public static final class ExistingTopicException
    extends AddTopicException {
        private static final long serialVersionUID = 177584683079519534L;

        public ExistingTopicException(String message) {
            super(message);
        }
    }

    public static final class InvalidTopicSpecificationException
    extends AddTopicException {
        private static final long serialVersionUID = -4737003936657468838L;

        public InvalidTopicSpecificationException(String message) {
            super(message);
        }
    }

    public static class AddTopicException
    extends SessionException {
        private static final long serialVersionUID = -7842778740912571614L;

        public AddTopicException(String message) {
            super(message);
        }
    }

    public static interface TopicRemovalResult {
        public int getRemovedCount();
    }

    public static enum AddTopicResult {
        CREATED,
        EXISTS;

    }

    public static interface MissingTopicNotification {
        public Map<String, String> getSessionProperties();

        default public SessionId getSessionId() {
            return Diffusion.sessionIdFromString(this.getSessionProperties().get("$SessionId"));
        }

        default public String getTopicPath() {
            return this.getTopicSelector().getPathPrefix();
        }

        public TopicSelector getTopicSelector();

        public List<String> getServerNames();
    }

    public static interface MissingTopicNotificationStream
    extends Stream {
        public void onMissingTopic(MissingTopicNotification var1);

        public static abstract class Default
        extends Stream.Default
        implements MissingTopicNotificationStream {
        }
    }
}

