/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client;

import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.features.control.Metrics;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.features.control.topics.SessionTrees;
import com.pushtechnology.diffusion.client.session.SessionFactory;
import com.pushtechnology.diffusion.client.session.SessionId;
import com.pushtechnology.diffusion.client.session.proxy.ProxyAuthenticationFactory;
import com.pushtechnology.diffusion.client.topics.TopicSelectors;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.datatype.DataTypes;
import java.util.Set;

public enum Diffusion {
    GLOBALS;

    private Implementation delegate;

    private Diffusion() {
        String implementation = "com.pushtechnology.diffusion.client.impl.SessionGlobals";
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.pushtechnology.diffusion.client.impl.SessionGlobals");
            this.delegate = (Implementation)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SessionFactory sessions() {
        return Diffusion.GLOBALS.delegate.getSessionFactory();
    }

    public static Credentials.Factory credentials() {
        return Diffusion.GLOBALS.delegate.getCredentialsFactory();
    }

    public static TopicSelectors topicSelectors() {
        return Diffusion.GLOBALS.delegate.getTopicSelectors();
    }

    public static ProxyAuthenticationFactory proxyAuthentication() {
        return Diffusion.GLOBALS.delegate.getProxyAuthenticationFactory();
    }

    public static DataTypes dataTypes() {
        return Diffusion.GLOBALS.delegate.getDataTypes();
    }

    public static String escape(String string) {
        return Diffusion.GLOBALS.delegate.escape(string);
    }

    public static TopicSpecification newTopicSpecification(TopicType topicType) {
        return Diffusion.GLOBALS.delegate.newTopicSpecification(topicType);
    }

    public static UpdateConstraint.Factory updateConstraints() {
        return Diffusion.GLOBALS.delegate.updateConstraints();
    }

    public static Set<String> stringToRoles(String string) {
        return Diffusion.GLOBALS.delegate.stringToRoles(string);
    }

    public static String rolesToString(Set<String> roles) {
        return Diffusion.GLOBALS.delegate.rolesToString(roles);
    }

    public static SessionTrees.BranchMappingTable.Builder newBranchMappingTableBuilder() {
        return Diffusion.GLOBALS.delegate.newBranchMappingTableBuilder();
    }

    public static Metrics.SessionMetricCollector.Builder newSessionMetricCollectorBuilder() {
        return Diffusion.GLOBALS.delegate.newSessionMetricCollectorBuilder();
    }

    public static SessionId sessionIdFromString(String sessionIdAsString) throws IllegalArgumentException {
        return Diffusion.GLOBALS.delegate.sessionIdFromString(sessionIdAsString);
    }

    public static Metrics.TopicMetricCollector.Builder newTopicMetricCollectorBuilder() {
        return Diffusion.GLOBALS.delegate.newTopicMetricCollectorBuilder();
    }

    @Deprecated
    public static RemoteServers.RemoteServer.Builder newRemoteServerBuilder() {
        return Diffusion.GLOBALS.delegate.newRemoteServerBuilder();
    }

    public static <B extends RemoteServers.RemoteServer.RemoteServerBuilder<B>> B newRemoteServerBuilder(Class<B> builderInterface) throws IllegalArgumentException {
        return Diffusion.GLOBALS.delegate.newRemoteServerBuilder(builderInterface);
    }

    public static interface Implementation {
        public SessionFactory getSessionFactory();

        public Credentials.Factory getCredentialsFactory();

        public TopicSelectors getTopicSelectors();

        public ProxyAuthenticationFactory getProxyAuthenticationFactory();

        public DataTypes getDataTypes();

        public TopicSpecification newTopicSpecification(TopicType var1);

        public UpdateConstraint.Factory updateConstraints();

        public Set<String> stringToRoles(String var1);

        public String rolesToString(Set<String> var1);

        public String escape(String var1);

        public SessionTrees.BranchMappingTable.Builder newBranchMappingTableBuilder();

        public Metrics.SessionMetricCollector.Builder newSessionMetricCollectorBuilder();

        public Metrics.TopicMetricCollector.Builder newTopicMetricCollectorBuilder();

        public RemoteServers.RemoteServer.Builder newRemoteServerBuilder();

        public <B extends RemoteServers.RemoteServer.RemoteServerBuilder<B>> B newRemoteServerBuilder(Class<B> var1) throws IllegalArgumentException;

        public SessionId sessionIdFromString(String var1) throws IllegalArgumentException;
    }
}

