/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.client.features.control.clients;

import com.pushtechnology.diffusion.client.callbacks.Registration;
import com.pushtechnology.diffusion.client.callbacks.ServerHandler;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.features.Callback;
import com.pushtechnology.diffusion.client.features.ContextCallback;
import com.pushtechnology.diffusion.client.features.ServerHandler;
import com.pushtechnology.diffusion.client.features.control.clients.MessageQueuePolicy;
import com.pushtechnology.diffusion.client.session.Feature;
import com.pushtechnology.diffusion.client.session.SessionId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientControl
extends Feature {
    public CompletableFuture<Registration> setSessionPropertiesListener(SessionPropertiesStream var1, String ... var2);

    @Deprecated
    public void setSessionPropertiesListener(SessionPropertiesListener var1, String ... var2);

    public CompletableFuture<Map<String, String>> getSessionProperties(SessionId var1, Collection<String> var2);

    @Deprecated
    public void getSessionProperties(SessionId var1, Collection<String> var2, SessionPropertiesCallback var3);

    @Deprecated
    public <C> void getSessionProperties(SessionId var1, Collection<String> var2, C var3, SessionPropertiesContextCallback<C> var4);

    public CompletableFuture<Map<String, String>> setSessionProperties(SessionId var1, Map<String, String> var2);

    public CompletableFuture<SessionFilterOperationResult> setSessionProperties(String var1, Map<String, String> var2);

    public CompletableFuture<Registration> setQueueEventHandler(QueueEventStream var1);

    @Deprecated
    public void setQueueEventHandler(QueueEventHandler var1);

    public CompletableFuture<?> close(SessionId var1);

    public CompletableFuture<SessionFilterOperationResult> close(String var1);

    @Deprecated
    public void close(SessionId var1, ClientCallback var2);

    @Deprecated
    public <C> void close(SessionId var1, C var2, ClientContextCallback<C> var3);

    public CompletableFuture<?> setConflated(SessionId var1, boolean var2);

    public CompletableFuture<SessionFilterOperationResult> setConflated(String var1, boolean var2);

    @Deprecated
    public void setConflated(SessionId var1, boolean var2, ClientCallback var3);

    @Deprecated
    public <C> void setConflated(SessionId var1, boolean var2, C var3, ClientContextCallback<C> var4);

    @Deprecated
    public SessionId sessionIdFromString(String var1) throws IllegalArgumentException;

    public CompletableFuture<?> changeRoles(SessionId var1, Set<String> var2, Set<String> var3) throws IllegalArgumentException;

    public CompletableFuture<Integer> changeRoles(String var1, Set<String> var2, Set<String> var3) throws IllegalArgumentException;

    public static interface SessionFilterOperationResult {
        public int selected();
    }

    public static enum CloseReason {
        CONNECTION_LOST,
        IO_EXCEPTION,
        CLIENT_UNRESPONSIVE,
        MESSAGE_QUEUE_LIMIT_REACHED,
        CLOSED_BY_CLIENT,
        MESSAGE_TOO_LARGE,
        INTERNAL_ERROR,
        INVALID_INBOUND_MESSAGE,
        ABORTED,
        LOST_MESSAGES,
        SERVER_CLOSING,
        CLOSED_BY_CONTROLLER,
        FAILED_OVER;

    }

    public static interface SessionPropertiesStream
    extends Stream {
        public void onSessionOpen(SessionId var1, Map<String, String> var2);

        public void onSessionEvent(SessionId var1, EventType var2, Map<String, String> var3, Map<String, String> var4);

        public void onSessionClose(SessionId var1, Map<String, String> var2, CloseReason var3);

        public static class Default
        extends Stream.Default
        implements SessionPropertiesStream {
            private static final Logger LOG = LoggerFactory.getLogger(SessionPropertiesListener.Default.class);

            @Override
            public void onSessionOpen(SessionId sessionId, Map<String, String> properties) {
                LOG.debug("{} - Client session {} opened : {}", new Object[]{this, sessionId, properties});
            }

            @Override
            public void onSessionEvent(SessionId sessionId, EventType eventType, Map<String, String> properties, Map<String, String> previousValues) {
                LOG.debug("{} - Client session {} event : {}, Properties={}, Previous Values={}", new Object[]{this, sessionId, eventType, properties, previousValues});
            }

            @Override
            public void onSessionClose(SessionId sessionId, Map<String, String> properties, CloseReason closeReason) {
                LOG.debug("{} - Client session {} closed - {} : {}", new Object[]{this, sessionId, closeReason, properties});
            }
        }

        public static enum EventType {
            UPDATED,
            RECONNECTED,
            FAILED_OVER,
            DISCONNECTED;

        }
    }

    @Deprecated
    public static interface QueueEventHandler
    extends ServerHandler {
        public void onUpperThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public void onLowerThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public static class Default
        extends ServerHandler.Default
        implements QueueEventHandler {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onUpperThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Upper queue threshold crossed", new Object[]{this, sessionId, policy});
            }

            @Override
            public void onLowerThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Lower queue threshold crossed", new Object[]{this, sessionId, policy});
            }
        }
    }

    public static interface QueueEventStream
    extends Stream {
        public void onUpperThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public void onLowerThresholdCrossed(SessionId var1, MessageQueuePolicy var2);

        public static class Default
        extends Stream.Default
        implements QueueEventStream {
            private static final Logger LOG = LoggerFactory.getLogger(QueueEventHandler.Default.class);

            @Override
            public void onUpperThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Upper queue threshold crossed", new Object[]{this, sessionId, policy});
            }

            @Override
            public void onLowerThresholdCrossed(SessionId sessionId, MessageQueuePolicy policy) {
                LOG.debug("{} - Session {} with policy {} : Lower queue threshold crossed", new Object[]{this, sessionId, policy});
            }
        }
    }

    @Deprecated
    public static interface ClientContextCallback<C>
    extends ContextCallback<C> {
        public void onComplete(C var1);

        public static class Default<C>
        extends ContextCallback.Default<C>
        implements ClientContextCallback<C> {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onComplete(C context) {
                LOG.debug("{} - Client operation complete, context={}", (Object)this, context);
            }
        }
    }

    @Deprecated
    public static interface ClientCallback
    extends Callback {
        public void onComplete();

        public static class Default
        extends Callback.Default
        implements ClientCallback {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onComplete() {
                LOG.debug("{} - Client operation complete", (Object)this);
            }
        }
    }

    @Deprecated
    public static interface SessionPropertiesContextCallback<C>
    extends com.pushtechnology.diffusion.client.callbacks.ContextCallback<C> {
        public void onReply(C var1, SessionId var2, Map<String, String> var3);

        public void onUnknownSession(C var1, SessionId var2);
    }

    @Deprecated
    public static interface SessionPropertiesCallback
    extends com.pushtechnology.diffusion.client.callbacks.Callback {
        public void onReply(SessionId var1, Map<String, String> var2);

        public void onUnknownSession(SessionId var1);
    }

    @Deprecated
    public static interface SessionPropertiesListener
    extends com.pushtechnology.diffusion.client.callbacks.ServerHandler {
        public void onSessionOpen(SessionId var1, Map<String, String> var2);

        public void onSessionEvent(SessionId var1, EventType var2, Map<String, String> var3, Map<String, String> var4);

        public void onSessionClose(SessionId var1, Map<String, String> var2, CloseReason var3);

        public static class Default
        extends ServerHandler.Default
        implements SessionPropertiesListener {
            private static final Logger LOG = LoggerFactory.getLogger(Default.class);

            @Override
            public void onSessionOpen(SessionId sessionId, Map<String, String> properties) {
                LOG.debug("{} - Client session {} opened : {}", new Object[]{this, sessionId, properties});
            }

            @Override
            public void onSessionEvent(SessionId sessionId, EventType eventType, Map<String, String> properties, Map<String, String> previousValues) {
                LOG.debug("{} - Client session {} event : {}, Properties={}, Previous Values={}", new Object[]{this, sessionId, eventType, properties, previousValues});
            }

            @Override
            public void onSessionClose(SessionId sessionId, Map<String, String> properties, CloseReason closeReason) {
                LOG.debug("{} - Client session {} closed - {} : {}", new Object[]{this, sessionId, closeReason, properties});
            }
        }

        public static enum EventType {
            UPDATED,
            RECONNECTED,
            FAILED_OVER,
            DISCONNECTED;

        }
    }
}

