/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github;

import com.dipien.github.IRepositoryIdProvider;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class RepositoryId
implements IRepositoryIdProvider,
Serializable {
    private static final long serialVersionUID = -57313931704393200L;
    private final String owner;
    private final String name;

    public static RepositoryId createFromUrl(URL url) {
        return url != null ? RepositoryId.createFromId(url.getPath()) : null;
    }

    public static RepositoryId createFromId(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        String owner = null;
        String name = null;
        for (String segment : id.split("/")) {
            if (segment.length() <= 0) continue;
            if (owner == null) {
                owner = segment;
                continue;
            }
            if (name != null) break;
            name = segment;
        }
        return owner != null && owner.length() > 0 && name != null && name.length() > 0 ? new RepositoryId(owner, name) : null;
    }

    public static RepositoryId createFromUrl(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        try {
            return RepositoryId.createFromUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static RepositoryId create(String owner, String name) {
        return new RepositoryId(owner, name);
    }

    public RepositoryId(String owner, String name) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner cannot be null");
        }
        if (owner.length() == 0) {
            throw new IllegalArgumentException("Owner cannot be empty");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.owner = owner;
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String generateId() {
        return this.owner + "/" + this.name;
    }

    public int hashCode() {
        return this.generateId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RepositoryId)) {
            return false;
        }
        RepositoryId other = (RepositoryId)obj;
        return this.name.equals(other.name) && this.owner.equals(other.owner);
    }

    public String toString() {
        return this.generateId();
    }
}

