/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.client;

import com.dipien.github.client.DateFormatter;
import com.dipien.github.event.CommitCommentPayload;
import com.dipien.github.event.CreatePayload;
import com.dipien.github.event.DeletePayload;
import com.dipien.github.event.DownloadPayload;
import com.dipien.github.event.Event;
import com.dipien.github.event.EventPayload;
import com.dipien.github.event.FollowPayload;
import com.dipien.github.event.ForkApplyPayload;
import com.dipien.github.event.ForkPayload;
import com.dipien.github.event.GistPayload;
import com.dipien.github.event.GollumPayload;
import com.dipien.github.event.IssueCommentPayload;
import com.dipien.github.event.IssuesPayload;
import com.dipien.github.event.MemberPayload;
import com.dipien.github.event.PublicPayload;
import com.dipien.github.event.PullRequestPayload;
import com.dipien.github.event.PullRequestReviewCommentPayload;
import com.dipien.github.event.PushPayload;
import com.dipien.github.event.ReleasePayload;
import com.dipien.github.event.TeamAddPayload;
import com.dipien.github.event.WatchPayload;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;

public class EventFormatter
implements JsonDeserializer<Event> {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateFormatter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Class payloadClass;
        Event event = (Event)this.gson.fromJson(json, Event.class);
        if (event == null || !json.isJsonObject()) {
            return event;
        }
        JsonElement rawPayload = json.getAsJsonObject().get("payload");
        if (rawPayload == null || !rawPayload.isJsonObject()) {
            return event;
        }
        String type = event.getType();
        if (type == null || type.length() == 0) {
            return event;
        }
        if ("CommitCommentEvent".equals(type)) {
            payloadClass = CommitCommentPayload.class;
        } else if ("CreateEvent".equals(type)) {
            payloadClass = CreatePayload.class;
        } else if ("DeleteEvent".equals(type)) {
            payloadClass = DeletePayload.class;
        } else if ("DownloadEvent".equals(type)) {
            payloadClass = DownloadPayload.class;
        } else if ("FollowEvent".equals(type)) {
            payloadClass = FollowPayload.class;
        } else if ("ForkEvent".equals(type)) {
            payloadClass = ForkPayload.class;
        } else if ("ForkApplyEvent".equals(type)) {
            payloadClass = ForkApplyPayload.class;
        } else if ("GistEvent".equals(type)) {
            payloadClass = GistPayload.class;
        } else if ("GollumEvent".equals(type)) {
            payloadClass = GollumPayload.class;
        } else if ("IssueCommentEvent".equals(type)) {
            payloadClass = IssueCommentPayload.class;
        } else if ("IssuesEvent".equals(type)) {
            payloadClass = IssuesPayload.class;
        } else if ("MemberEvent".equals(type)) {
            payloadClass = MemberPayload.class;
        } else if ("PublicEvent".equals(type)) {
            payloadClass = PublicPayload.class;
        } else if ("PullRequestEvent".equals(type)) {
            payloadClass = PullRequestPayload.class;
        } else if ("PullRequestReviewCommentEvent".equals(type)) {
            payloadClass = PullRequestReviewCommentPayload.class;
        } else if ("PushEvent".equals(type)) {
            payloadClass = PushPayload.class;
        } else if ("ReleaseEvent".equals(type)) {
            payloadClass = ReleasePayload.class;
        } else if ("TeamAddEvent".equals(type)) {
            payloadClass = TeamAddPayload.class;
        } else if ("WatchEvent".equals(type)) {
            payloadClass = WatchPayload.class;
        } else {
            return event;
        }
        try {
            EventPayload typedPayload = (EventPayload)context.deserialize(rawPayload, payloadClass);
            return event.setPayload(typedPayload);
        }
        catch (JsonParseException jpe) {
            return event;
        }
    }
}

