/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.client;

import com.dipien.github.client.GitHubResponse;

public class PageLinks {
    private static final String DELIM_LINKS = ",";
    private static final String DELIM_LINK_PARAM = ";";
    private String first;
    private String last;
    private String next;
    private String prev;

    public PageLinks(GitHubResponse response) {
        String linkHeader = response.getHeader("Link");
        if (linkHeader != null) {
            String[] links;
            for (String link : links = linkHeader.split(DELIM_LINKS)) {
                String linkPart;
                String[] segments = link.split(DELIM_LINK_PARAM);
                if (segments.length < 2 || !(linkPart = segments[0].trim()).startsWith("<") || !linkPart.endsWith(">")) continue;
                linkPart = linkPart.substring(1, linkPart.length() - 1);
                for (int i = 1; i < segments.length; ++i) {
                    String[] rel = segments[i].trim().split("=");
                    if (rel.length < 2 || !"rel".equals(rel[0])) continue;
                    String relValue = rel[1];
                    if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
                        relValue = relValue.substring(1, relValue.length() - 1);
                    }
                    if ("first".equals(relValue)) {
                        this.first = linkPart;
                        continue;
                    }
                    if ("last".equals(relValue)) {
                        this.last = linkPart;
                        continue;
                    }
                    if ("next".equals(relValue)) {
                        this.next = linkPart;
                        continue;
                    }
                    if (!"prev".equals(relValue)) continue;
                    this.prev = linkPart;
                }
            }
        } else {
            this.next = response.getHeader("X-Next");
            this.last = response.getHeader("X-Last");
        }
    }

    public String getFirst() {
        return this.first;
    }

    public String getLast() {
        return this.last;
    }

    public String getNext() {
        return this.next;
    }

    public String getPrev() {
        return this.prev;
    }
}

