/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.client;

import com.dipien.github.FieldError;
import com.dipien.github.RequestError;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;

public class RequestException
extends IOException {
    private static final String FIELD_INVALID_WITH_VALUE = "Invalid value of ''{0}'' for ''{1}'' field";
    private static final String FIELD_INVALID = "Invalid value for ''{0}'' field";
    private static final String FIELD_MISSING = "Missing required ''{0}'' field";
    private static final String FIELD_ERROR = "Error with ''{0}'' field in {1} resource";
    private static final String FIELD_EXISTS = "{0} resource with ''{1}'' field already exists";
    private static final long serialVersionUID = 1197051396535284852L;
    private final RequestError error;
    private final int status;

    public RequestException(RequestError error, int status) {
        this.error = error;
        this.status = status;
    }

    @Override
    public String getMessage() {
        return this.error != null ? this.formatErrors() : super.getMessage();
    }

    public RequestError getError() {
        return this.error;
    }

    public int getStatus() {
        return this.status;
    }

    protected String format(FieldError error) {
        String message;
        String code = error.getCode();
        String value = error.getValue();
        String field = error.getField();
        if ("invalid".equals(code)) {
            if (value != null) {
                return MessageFormat.format(FIELD_INVALID_WITH_VALUE, value, field);
            }
            return MessageFormat.format(FIELD_INVALID, field);
        }
        if ("missing_field".equals(code)) {
            return MessageFormat.format(FIELD_MISSING, field);
        }
        if ("already_exists".equals(code)) {
            return MessageFormat.format(FIELD_EXISTS, error.getResource(), field);
        }
        if ("custom".equals(code) && (message = error.getMessage()) != null && message.length() > 0) {
            return message;
        }
        return MessageFormat.format(FIELD_ERROR, field, error.getResource());
    }

    public String formatErrors() {
        StringBuilder message;
        String errorMessage = this.error.getMessage();
        if (errorMessage == null) {
            errorMessage = "";
        }
        if ((message = new StringBuilder(errorMessage)).length() > 0) {
            message.append(' ').append('(').append(this.status).append(')');
        } else {
            message.append(this.status);
        }
        List<FieldError> errors = this.error.getErrors();
        if (errors != null && errors.size() > 0) {
            message.append(':');
            for (FieldError fieldError : errors) {
                message.append(' ').append(this.format(fieldError)).append(',');
            }
            message.deleteCharAt(message.length() - 1);
        }
        return message.toString();
    }
}

