/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.service;

import com.dipien.github.CommitComment;
import com.dipien.github.CommitStatus;
import com.dipien.github.IRepositoryIdProvider;
import com.dipien.github.RepositoryCommit;
import com.dipien.github.RepositoryCommitCompare;
import com.dipien.github.client.GitHubClient;
import com.dipien.github.client.GitHubRequest;
import com.dipien.github.client.PageIterator;
import com.dipien.github.client.PagedRequest;
import com.dipien.github.service.GitHubService;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;

public class CommitService
extends GitHubService {
    public CommitService() {
    }

    public CommitService(GitHubClient client) {
        super(client);
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository) throws IOException {
        return this.getCommits(repository, null, null);
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository, String sha, String path) throws IOException {
        return this.getAll(this.pageCommits(repository, sha, path));
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository) {
        return this.pageCommits(repository, null, null);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, int size) {
        return this.pageCommits(repository, null, null, size);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, String sha, String path) {
        return this.pageCommits(repository, sha, path, 100);
    }

    public PageIterator<RepositoryCommit> pageCommits(IRepositoryIdProvider repository, String sha, String path, int size) {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        PagedRequest request = this.createPagedRequest(1, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryCommit>>(){}.getType());
        if (sha != null || path != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (sha != null) {
                params.put("sha", sha);
            }
            if (path != null) {
                params.put("path", path);
            }
            request.setParams(params);
        }
        return this.createPageIterator(request);
    }

    public RepositoryCommit getCommit(IRepositoryIdProvider repository, String sha) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)RepositoryCommit.class));
        return (RepositoryCommit)this.client.get(request).getBody();
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository, String sha) throws IOException {
        return this.getAll(this.pageComments(repository, sha));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha) {
        return this.pageComments(repository, sha, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha, int size) {
        return this.pageComments(repository, sha, 1, size);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, String sha, int start, int size) {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }

    public CommitComment getComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/comments");
        uri.append('/').append(commentId);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)CommitComment.class));
        return (CommitComment)this.client.get(request).getBody();
    }

    public CommitComment addComment(IRepositoryIdProvider repository, String sha, CommitComment comment) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("Sha cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public CommitComment editComment(IRepositoryIdProvider repository, CommitComment comment) throws IOException {
        String id = this.getId(repository);
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }

    public RepositoryCommitCompare compare(IRepositoryIdProvider repository, String base, String head) throws IOException {
        String id = this.getId(repository);
        if (base == null) {
            throw new IllegalArgumentException("Base cannot be null");
        }
        if (base.length() == 0) {
            throw new IllegalArgumentException("Base cannot be empty");
        }
        if (head == null) {
            throw new IllegalArgumentException("Head cannot be null");
        }
        if (head.length() == 0) {
            throw new IllegalArgumentException("Head cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/compare");
        uri.append('/').append(base).append("...").append(head);
        GitHubRequest request = this.createRequest();
        request.setType((Type)((Object)RepositoryCommitCompare.class));
        request.setUri(uri);
        return (RepositoryCommitCompare)this.client.get(request).getBody();
    }

    public List<CommitStatus> getStatuses(IRepositoryIdProvider repository, String sha) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/statuses");
        uri.append('/').append(sha);
        PagedRequest request = this.createPagedRequest();
        request.setType(new TypeToken<List<CommitStatus>>(){}.getType());
        request.setUri(uri);
        return this.getAll(request);
    }

    public CommitStatus createStatus(IRepositoryIdProvider repository, String sha, CommitStatus status) throws IOException {
        String id = this.getId(repository);
        if (sha == null) {
            throw new IllegalArgumentException("SHA-1 cannot be null");
        }
        if (sha.length() == 0) {
            throw new IllegalArgumentException("SHA-1 cannot be empty");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        HashMap<String, String> params = new HashMap<String, String>(3, 1.0f);
        if (status.getState() != null) {
            params.put("state", status.getState());
        }
        if (status.getTargetUrl() != null) {
            params.put("target_url", status.getTargetUrl());
        }
        if (status.getDescription() != null) {
            params.put("description", status.getDescription());
        }
        if (status.getContext() != null) {
            params.put("context", status.getContext());
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/statuses");
        uri.append('/').append(sha);
        return (CommitStatus)this.client.post(uri.toString(), params, (Type)((Object)CommitStatus.class));
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageComments(repository));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository) {
        return this.pageComments(repository, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int size) {
        return this.pageComments(repository, 1, size);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int start, int size) {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }
}

