/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.service;

import com.dipien.github.IRepositoryIdProvider;
import com.dipien.github.client.GitHubClient;
import com.dipien.github.client.PageIterator;
import com.dipien.github.client.PagedRequest;
import com.dipien.github.event.Event;
import com.dipien.github.service.GitHubService;
import com.google.gson.reflect.TypeToken;
import java.util.List;

public class EventService
extends GitHubService {
    public EventService() {
    }

    public EventService(GitHubClient client) {
        super(client);
    }

    public PageIterator<Event> pagePublicEvents() {
        return this.pagePublicEvents(100);
    }

    public PageIterator<Event> pagePublicEvents(int size) {
        return this.pagePublicEvents(1, size);
    }

    public PageIterator<Event> pagePublicEvents(int start, int size) {
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri("/events");
        request.setType(new TypeToken<List<Event>>(){}.getType());
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository) {
        return this.pageEvents(repository, 100);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository, int size) {
        return this.pageEvents(repository, 1, size);
    }

    public PageIterator<Event> pageEvents(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<Event> request = this.createRepoEventRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository) {
        return this.pageNetworkEvents(repository, 100);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository, int size) {
        return this.pageNetworkEvents(repository, 1, size);
    }

    public PageIterator<Event> pageNetworkEvents(IRepositoryIdProvider repository, int start, int size) {
        PagedRequest<Event> request = this.createNetworkRepoEventRequest(repository, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageOrgEvents(String org) {
        return this.pageOrgEvents(org, 100);
    }

    public PageIterator<Event> pageOrgEvents(String org, int size) {
        return this.pageOrgEvents(org, 1, size);
    }

    public PageIterator<Event> pageOrgEvents(String org, int start, int size) {
        PagedRequest<Event> request = this.createOrgEventRequest(org, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user) {
        return this.pageUserReceivedEvents(user, false);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user, boolean isPublic) {
        return this.pageUserReceivedEvents(user, isPublic, 100);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user, boolean isPublic, int size) {
        return this.pageUserReceivedEvents(user, isPublic, 1, size);
    }

    public PageIterator<Event> pageUserReceivedEvents(String user, boolean isPublic, int start, int size) {
        PagedRequest<Event> request = this.createUserReceivedEventRequest(user, isPublic, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageUserEvents(String user) {
        return this.pageUserEvents(user, false);
    }

    public PageIterator<Event> pageUserEvents(String user, boolean isPublic) {
        return this.pageUserEvents(user, isPublic, 100);
    }

    public PageIterator<Event> pageUserEvents(String user, boolean isPublic, int size) {
        return this.pageUserEvents(user, isPublic, 1, size);
    }

    public PageIterator<Event> pageUserEvents(String user, boolean isPublic, int start, int size) {
        PagedRequest<Event> request = this.createUserEventRequest(user, isPublic, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Event> pageUserOrgEvents(String user, String org) {
        return this.pageUserOrgEvents(user, org, 100);
    }

    public PageIterator<Event> pageUserOrgEvents(String user, String org, int size) {
        return this.pageUserOrgEvents(user, org, 1, size);
    }

    public PageIterator<Event> pageUserOrgEvents(String user, String org, int start, int size) {
        PagedRequest<Event> request = this.createUserOrgEventRequest(user, org, start, size);
        return this.createPageIterator(request);
    }

    protected PagedRequest<Event> createRepoEventRequest(IRepositoryIdProvider repository, int start, int size) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/events");
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }

    protected PagedRequest<Event> createNetworkRepoEventRequest(IRepositoryIdProvider repository, int start, int size) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/networks");
        uri.append('/').append(repoId);
        uri.append("/events");
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }

    protected PagedRequest<Event> createOrgEventRequest(String org, int start, int size) {
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(org);
        uri.append("/events");
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }

    protected PagedRequest<Event> createUserReceivedEventRequest(String user, boolean isPublic, int start, int size) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/received_events");
        if (isPublic) {
            uri.append("/public");
        }
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }

    protected PagedRequest<Event> createUserEventRequest(String user, boolean isPublic, int start, int size) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/events");
        if (isPublic) {
            uri.append("/public");
        }
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }

    protected PagedRequest<Event> createUserOrgEventRequest(String user, String org, int start, int size) {
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/events").append("/orgs");
        uri.append('/').append(org);
        PagedRequest<Event> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Event>>(){}.getType());
        return request;
    }
}

