/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.service;

import com.dipien.github.CommitComment;
import com.dipien.github.CommitFile;
import com.dipien.github.IRepositoryIdProvider;
import com.dipien.github.MergeStatus;
import com.dipien.github.PullRequest;
import com.dipien.github.RepositoryCommit;
import com.dipien.github.client.GitHubClient;
import com.dipien.github.client.GitHubRequest;
import com.dipien.github.client.PageIterator;
import com.dipien.github.client.PagedRequest;
import com.dipien.github.service.GitHubService;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PullRequestService
extends GitHubService {
    public static final String PR_TITLE = "title";
    public static final String PR_BODY = "body";
    public static final String PR_BASE = "base";
    public static final String PR_HEAD = "head";
    public static final String PR_STATE = "state";
    public static final String ISSUE = "issue";

    public PullRequestService() {
    }

    public PullRequestService(GitHubClient client) {
        super(client);
    }

    public PullRequest getPullRequest(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)PullRequest.class));
        return (PullRequest)this.client.get(request).getBody();
    }

    public PullRequest getPullRequest(IRepositoryIdProvider repository, String state, String head, String base) throws IOException {
        PullRequest pullRequest = null;
        List<PullRequest> pullRequests = this.getAll(this.pagePullRequests(repository, state, head, base));
        if (pullRequests.size() > 1) {
            throw new RuntimeException("Expected just one pull request");
        }
        if (!pullRequests.isEmpty()) {
            pullRequest = pullRequests.get(0);
        }
        return pullRequest;
    }

    protected PagedRequest<PullRequest> createPagedRequest(IRepositoryIdProvider provider, String state, String head, String base, int start, int size) {
        String id = this.getId(provider);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        PagedRequest<PullRequest> request = this.createPagedRequest(start, size);
        request.setUri(uri);
        HashMap<String, String> params = new HashMap<String, String>();
        if (state != null) {
            params.put(PR_STATE, state);
        }
        if (head != null) {
            params.put(PR_HEAD, head);
        }
        if (base != null) {
            params.put(PR_BASE, base);
        }
        if (!params.isEmpty()) {
            request.setParams(params);
        }
        request.setType(new TypeToken<List<PullRequest>>(){}.getType());
        return request;
    }

    public List<PullRequest> getPullRequests(IRepositoryIdProvider repository, String state) throws IOException {
        return this.getAll(this.pagePullRequests(repository, state, null, null));
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, String head, String base) {
        return this.pagePullRequests(repository, state, head, base, 100);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, String head, String base, int size) {
        return this.pagePullRequests(repository, state, head, base, 1, size);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, String head, String base, int start, int size) {
        PagedRequest<PullRequest> request = this.createPagedRequest(repository, state, head, base, start, size);
        return this.createPageIterator(request);
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, String title, String body, String head, String base) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PR_TITLE, title);
        params.put(PR_BODY, body);
        params.put(PR_BASE, base);
        params.put(PR_HEAD, head);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, int issueId, String head, String base) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ISSUE, issueId);
        params.put(PR_HEAD, head);
        params.put(PR_BASE, base);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public PullRequest editPullRequest(IRepositoryIdProvider repository, int number, String title, String body, String state, String base) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        uri.append('/').append(number);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PR_TITLE, title);
        params.put(PR_BODY, body);
        params.put(PR_STATE, state);
        params.put(PR_BASE, base);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public PullRequest closePullRequest(IRepositoryIdProvider repository, int number) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        uri.append('/').append(number);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PR_STATE, "closed");
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/commits");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryCommit>>(){}.getType());
        return this.getAll(request);
    }

    public List<CommitFile> getFiles(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/files");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitFile>>(){}.getType());
        return this.getAll(request);
    }

    public boolean isMerged(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/merge");
        return this.check(uri.toString());
    }

    public MergeStatus merge(IRepositoryIdProvider repository, int number, String commitMessage) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(number);
        uri.append("/merge");
        return (MergeStatus)this.client.put(uri.toString(), Collections.singletonMap("commit_message", commitMessage), (Type)((Object)MergeStatus.class));
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository, int id) throws IOException {
        return this.getAll(this.pageComments(repository, id));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id) {
        return this.pageComments(repository, id, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id, int size) {
        return this.pageComments(repository, id, 1, size);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id, int start, int size) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }

    public CommitComment getComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)CommitComment.class));
        return (CommitComment)this.client.get(request).getBody();
    }

    public CommitComment createComment(IRepositoryIdProvider repository, int id, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public CommitComment replyToComment(IRepositoryIdProvider repository, int pullRequestId, int commentId, String body) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(pullRequestId);
        uri.append("/comments");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("in_reply_to", Integer.toString(commentId));
        params.put(PR_BODY, body);
        return (CommitComment)this.client.post(uri.toString(), params, (Type)((Object)CommitComment.class));
    }

    public CommitComment editComment(IRepositoryIdProvider repository, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }
}

