/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.service;

import com.dipien.github.IRepositoryIdProvider;
import com.dipien.github.Release;
import com.dipien.github.client.GitHubClient;
import com.dipien.github.client.GitHubRequest;
import com.dipien.github.client.PageIterator;
import com.dipien.github.client.PagedRequest;
import com.dipien.github.client.RequestException;
import com.dipien.github.service.GitHubService;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class ReleaseService
extends GitHubService {
    public ReleaseService(GitHubClient client) {
        super(client);
    }

    public Release createRelease(IRepositoryIdProvider repositoryIdProvider, Release release) throws IOException {
        String repoId = this.getId(repositoryIdProvider);
        if (release == null) {
            throw new IllegalArgumentException("Release cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/releases");
        return (Release)this.client.post(uri.toString(), release, (Type)((Object)Release.class));
    }

    public List<Release> listReleases(IRepositoryIdProvider repositoryIdProvider) throws IOException {
        String repoId = this.getId(repositoryIdProvider);
        return this.getAll(this.pageReleases(repoId));
    }

    public PageIterator<Release> pageReleases(String repoId) {
        return this.pageReleases(repoId, 1, 100);
    }

    public PageIterator<Release> pageReleases(String repoId, int start, int size) {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/releases");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri.toString());
        request.setType(new TypeToken<List<Release>>(){}.getType());
        return this.createPageIterator(request);
    }

    public Release getReleaseByTagName(IRepositoryIdProvider repositoryIdProvider, String tagName) throws IOException {
        String repoId = this.getId(repositoryIdProvider);
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/releases");
        uri.append("/tags");
        uri.append('/').append(tagName);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Release.class));
        try {
            return (Release)this.client.get(request).getBody();
        }
        catch (RequestException requestException) {
            if (requestException.getStatus() == 404) {
                return null;
            }
            throw requestException;
        }
    }
}

