/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.WebFormUserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Web Form Instance metadata containing information like created by, created time, etc.")
public class WebFormInstanceMetadata {
    @JsonProperty(value="expirationDateTime")
    private String expirationDateTime = null;
    @JsonProperty(value="createdDateTime")
    private String createdDateTime = null;
    @JsonProperty(value="createdBy")
    private WebFormUserInfo createdBy = null;
    @JsonProperty(value="lastModifiedDateTime")
    private String lastModifiedDateTime = null;
    @JsonProperty(value="lastModifiedBy")
    private WebFormUserInfo lastModifiedBy = null;

    public WebFormInstanceMetadata expirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @Schema(required=true, description="")
    public String getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public WebFormInstanceMetadata createdDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    @Schema(required=true, description="")
    public String getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(String createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public WebFormInstanceMetadata createdBy(WebFormUserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(required=true, description="The user that created the Web Form Instance")
    public WebFormUserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(WebFormUserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public WebFormInstanceMetadata lastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Schema(description="")
    public String getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(String lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    public WebFormInstanceMetadata lastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    @Schema(description="The user that last modified the Web Form Instance")
    public WebFormUserInfo getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(WebFormUserInfo lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormInstanceMetadata webFormInstanceMetadata = (WebFormInstanceMetadata)o;
        return Objects.equals(this.expirationDateTime, webFormInstanceMetadata.expirationDateTime) && Objects.equals(this.createdDateTime, webFormInstanceMetadata.createdDateTime) && Objects.equals(this.createdBy, webFormInstanceMetadata.createdBy) && Objects.equals(this.lastModifiedDateTime, webFormInstanceMetadata.lastModifiedDateTime) && Objects.equals(this.lastModifiedBy, webFormInstanceMetadata.lastModifiedBy);
    }

    public int hashCode() {
        return Objects.hash(this.expirationDateTime, this.createdDateTime, this.createdBy, this.lastModifiedDateTime, this.lastModifiedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormInstanceMetadata {\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    createdDateTime: ").append(this.toIndentedString(this.createdDateTime)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    lastModifiedDateTime: ").append(this.toIndentedString(this.lastModifiedDateTime)).append("\n");
        sb.append("    lastModifiedBy: ").append(this.toIndentedString(this.lastModifiedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

