/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.WebFormSummary;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A list of web form summary items.")
public class WebFormSummaryList {
    @JsonProperty(value="items")
    private List<WebFormSummary> items = null;
    @JsonProperty(value="resultSetSize")
    private BigDecimal resultSetSize = null;
    @JsonProperty(value="totalSetSize")
    private BigDecimal totalSetSize = null;
    @JsonProperty(value="startPosition")
    private BigDecimal startPosition = null;
    @JsonProperty(value="endPosition")
    private BigDecimal endPosition = null;
    @JsonProperty(value="nextUrl")
    private String nextUrl = null;
    @JsonProperty(value="previousUrl")
    private String previousUrl = null;

    public WebFormSummaryList items(List<WebFormSummary> items) {
        this.items = items;
        return this;
    }

    public WebFormSummaryList addItemsItem(WebFormSummary itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<WebFormSummary>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="Array of web form items with each containing summary.")
    public List<WebFormSummary> getItems() {
        return this.items;
    }

    public void setItems(List<WebFormSummary> items) {
        this.items = items;
    }

    public WebFormSummaryList resultSetSize(BigDecimal resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @Schema(example="1.0", description="Result set size for current page")
    public BigDecimal getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(BigDecimal resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public WebFormSummaryList totalSetSize(BigDecimal totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @Schema(example="1.0", description="Total result set size")
    public BigDecimal getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(BigDecimal totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public WebFormSummaryList startPosition(BigDecimal startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Schema(example="1.0", description="Starting position of fields returned for the current page")
    public BigDecimal getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(BigDecimal startPosition) {
        this.startPosition = startPosition;
    }

    public WebFormSummaryList endPosition(BigDecimal endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Schema(example="1.0", description="Ending position of fields returned for the current page")
    public BigDecimal getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(BigDecimal endPosition) {
        this.endPosition = endPosition;
    }

    public WebFormSummaryList nextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
        return this;
    }

    @Schema(description="Url for the next page of results")
    public String getNextUrl() {
        return this.nextUrl;
    }

    public void setNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
    }

    public WebFormSummaryList previousUrl(String previousUrl) {
        this.previousUrl = previousUrl;
        return this;
    }

    @Schema(description="Url for the previous page of results")
    public String getPreviousUrl() {
        return this.previousUrl;
    }

    public void setPreviousUrl(String previousUrl) {
        this.previousUrl = previousUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormSummaryList webFormSummaryList = (WebFormSummaryList)o;
        return Objects.equals(this.items, webFormSummaryList.items) && Objects.equals(this.resultSetSize, webFormSummaryList.resultSetSize) && Objects.equals(this.totalSetSize, webFormSummaryList.totalSetSize) && Objects.equals(this.startPosition, webFormSummaryList.startPosition) && Objects.equals(this.endPosition, webFormSummaryList.endPosition) && Objects.equals(this.nextUrl, webFormSummaryList.nextUrl) && Objects.equals(this.previousUrl, webFormSummaryList.previousUrl);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.resultSetSize, this.totalSetSize, this.startPosition, this.endPosition, this.nextUrl, this.previousUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormSummaryList {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    nextUrl: ").append(this.toIndentedString(this.nextUrl)).append("\n");
        sb.append("    previousUrl: ").append(this.toIndentedString(this.previousUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

