package com.docusign.webforms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** Web Form Instance metadata containing information like created by, created time, etc.. */
@Schema(
    description =
        "Web Form Instance metadata containing information like created by, created time, etc.")
public class WebFormInstanceMetadata implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("expirationDateTime")
  private String expirationDateTime = null;

  @JsonProperty("createdDateTime")
  private String createdDateTime = null;

  @JsonProperty("createdBy")
  private WebFormUserInfo createdBy = null;

  @JsonProperty("lastModifiedDateTime")
  private String lastModifiedDateTime = null;

  @JsonProperty("lastModifiedBy")
  private WebFormUserInfo lastModifiedBy = null;

  @JsonProperty("submittedDateTime")
  private String submittedDateTime = null;

  @JsonProperty("instanceSource")
  private InstanceSource instanceSource = null;

  /**
   * expirationDateTime.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata expirationDateTime(String expirationDateTime) {
    this.expirationDateTime = expirationDateTime;
    return this;
  }

  /**
   * Get expirationDateTime.
   *
   * @return expirationDateTime
   */
  @Schema(required = true, description = "")
  public String getExpirationDateTime() {
    return expirationDateTime;
  }

  /** setExpirationDateTime. */
  public void setExpirationDateTime(String expirationDateTime) {
    this.expirationDateTime = expirationDateTime;
  }

  /**
   * createdDateTime.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata createdDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
    return this;
  }

  /**
   * Get createdDateTime.
   *
   * @return createdDateTime
   */
  @Schema(required = true, description = "")
  public String getCreatedDateTime() {
    return createdDateTime;
  }

  /** setCreatedDateTime. */
  public void setCreatedDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
  }

  /**
   * createdBy.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata createdBy(WebFormUserInfo createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * The user that created the Web Form Instance.
   *
   * @return createdBy
   */
  @Schema(required = true, description = "The user that created the Web Form Instance")
  public WebFormUserInfo getCreatedBy() {
    return createdBy;
  }

  /** setCreatedBy. */
  public void setCreatedBy(WebFormUserInfo createdBy) {
    this.createdBy = createdBy;
  }

  /**
   * lastModifiedDateTime.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata lastModifiedDateTime(String lastModifiedDateTime) {
    this.lastModifiedDateTime = lastModifiedDateTime;
    return this;
  }

  /**
   * Get lastModifiedDateTime.
   *
   * @return lastModifiedDateTime
   */
  @Schema(description = "")
  public String getLastModifiedDateTime() {
    return lastModifiedDateTime;
  }

  /** setLastModifiedDateTime. */
  public void setLastModifiedDateTime(String lastModifiedDateTime) {
    this.lastModifiedDateTime = lastModifiedDateTime;
  }

  /**
   * lastModifiedBy.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata lastModifiedBy(WebFormUserInfo lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * The user that last modified the Web Form Instance.
   *
   * @return lastModifiedBy
   */
  @Schema(description = "The user that last modified the Web Form Instance")
  public WebFormUserInfo getLastModifiedBy() {
    return lastModifiedBy;
  }

  /** setLastModifiedBy. */
  public void setLastModifiedBy(WebFormUserInfo lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  /**
   * submittedDateTime.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata submittedDateTime(String submittedDateTime) {
    this.submittedDateTime = submittedDateTime;
    return this;
  }

  /**
   * Get submittedDateTime.
   *
   * @return submittedDateTime
   */
  @Schema(description = "")
  public String getSubmittedDateTime() {
    return submittedDateTime;
  }

  /** setSubmittedDateTime. */
  public void setSubmittedDateTime(String submittedDateTime) {
    this.submittedDateTime = submittedDateTime;
  }

  /**
   * instanceSource.
   *
   * @return WebFormInstanceMetadata
   */
  public WebFormInstanceMetadata instanceSource(InstanceSource instanceSource) {
    this.instanceSource = instanceSource;
    return this;
  }

  /**
   * Get instanceSource.
   *
   * @return instanceSource
   */
  @Schema(description = "")
  public InstanceSource getInstanceSource() {
    return instanceSource;
  }

  /** setInstanceSource. */
  public void setInstanceSource(InstanceSource instanceSource) {
    this.instanceSource = instanceSource;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebFormInstanceMetadata webFormInstanceMetadata = (WebFormInstanceMetadata) o;
    return Objects.equals(this.expirationDateTime, webFormInstanceMetadata.expirationDateTime)
        && Objects.equals(this.createdDateTime, webFormInstanceMetadata.createdDateTime)
        && Objects.equals(this.createdBy, webFormInstanceMetadata.createdBy)
        && Objects.equals(this.lastModifiedDateTime, webFormInstanceMetadata.lastModifiedDateTime)
        && Objects.equals(this.lastModifiedBy, webFormInstanceMetadata.lastModifiedBy)
        && Objects.equals(this.submittedDateTime, webFormInstanceMetadata.submittedDateTime)
        && Objects.equals(this.instanceSource, webFormInstanceMetadata.instanceSource);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(
        expirationDateTime,
        createdDateTime,
        createdBy,
        lastModifiedDateTime,
        lastModifiedBy,
        submittedDateTime,
        instanceSource);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebFormInstanceMetadata {\n");

    sb.append("    expirationDateTime: ").append(toIndentedString(expirationDateTime)).append("\n");
    sb.append("    createdDateTime: ").append(toIndentedString(createdDateTime)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    lastModifiedDateTime: ")
        .append(toIndentedString(lastModifiedDateTime))
        .append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    submittedDateTime: ").append(toIndentedString(submittedDateTime)).append("\n");
    sb.append("    instanceSource: ").append(toIndentedString(instanceSource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
