/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicBoolean;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicBooleanMatrix
extends AbstractMatrix {
    private byte[] values;

    public BasicBooleanMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new byte[rows * columns];
    }

    public BasicBooleanMatrix(int rows, int columns, List<byte[]> listOfArrays) throws Exception {
        super(rows, columns);
        this.values = new byte[rows * columns];
        if (listOfArrays == null || listOfArrays.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            byte[] array = listOfArrays.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicBooleanMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setBoolean(int row, int column, boolean value) {
        this.values[this.getIndex((int)row, (int)column)] = value ? (byte)1 : 0;
    }

    public boolean getBoolean(int row, int column) {
        return this.values[this.getIndex(row, column)] == 1;
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == -128;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = -128;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicBoolean(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LOGICAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_BOOL;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicBoolean.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int size = rows * columns;
        this.values = new byte[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readByte();
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (byte value : this.values) {
            out.writeByte(value);
        }
    }
}

