/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicLongVector
extends AbstractVector {
    private long[] values;

    public BasicLongVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicLongVector(List<Long> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicLongVector(long[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (long[])array.clone();
    }

    protected BasicLongVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new long[size];
    }

    protected BasicLongVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new long[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readLong();
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicLong(this.values[index]);
    }

    public long getLong(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.getNumber().longValue();
    }

    public void setLong(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Long.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_LONG;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicLong.class;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLongArray(this.values);
    }
}

