/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicSecond;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicSecondMatrix
extends BasicIntMatrix {
    public BasicSecondMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicSecondMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicSecondMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setSecond(int row, int column, LocalTime value) {
        this.setInt(row, column, Utils.countSeconds(value));
    }

    public LocalTime getSecond(int row, int column) {
        return Utils.parseSecond(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicSecond(this.getInt(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_SECOND;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicSecond.class;
    }
}

