/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.route.AbstractRangePartitionedTableRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class IntegralRangePartitionedTableRouter
extends AbstractRangePartitionedTableRouter {
    private Long[] ranges;
    private List<List<String>> locations;

    IntegralRangePartitionedTableRouter(AbstractVector values, BasicAnyVector locations) {
        if (values.getDataCategory() != Entity.DATA_CATEGORY.INTEGRAL) {
            throw new RuntimeException("expect a vector of integrals");
        }
        ArrayList<Long> longs = new ArrayList<Long>();
        for (int i = 0; i < values.rows(); ++i) {
            try {
                longs.add(values.get(i).getNumber().longValue());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.initialize(longs, locations);
    }

    private static <T extends Comparable<T>> boolean isSorted(List<T> theList) {
        Comparable previous = null;
        for (Comparable t : theList) {
            if (previous != null && t.compareTo(previous) < 0) {
                return false;
            }
            previous = t;
        }
        return true;
    }

    private void initialize(List<Long> longs, BasicAnyVector locations) {
        boolean isScalar;
        if (locations.rows() <= 0) {
            throw new RuntimeException("requires at least one location");
        }
        if (locations.getEntity(0).getDataType() != Entity.DATA_TYPE.DT_STRING) {
            throw new RuntimeException("location must be a string");
        }
        if (!IntegralRangePartitionedTableRouter.isSorted(longs)) {
            throw new RuntimeException("ranges " + longs.toString() + " not sorted!");
        }
        if (longs.size() != locations.rows() + 1) {
            throw new RuntimeException("expect # locations == # range values - 1");
        }
        this.ranges = longs.toArray(new Long[longs.size()]);
        this.locations = new ArrayList<List<String>>();
        boolean bl = isScalar = locations.getEntity(0).getDataForm() == Entity.DATA_FORM.DF_SCALAR;
        if (isScalar) {
            for (int i = 0; i < locations.rows(); ++i) {
                BasicString location = (BasicString)locations.get(i);
                this.locations.add(Arrays.asList(location.getString()));
            }
        } else {
            for (int i = 0; i < locations.rows(); ++i) {
                BasicStringVector locationVector = (BasicStringVector)locations.getEntity(i);
                this.locations.add(new ArrayList());
                for (int j = 0; j < locationVector.rows(); ++j) {
                    this.locations.get(this.locations.size() - 1).add(((BasicString)locationVector.get(j)).getString());
                }
            }
        }
    }

    @Override
    public String route(Scalar partitionColumn) {
        if (partitionColumn.getDataCategory() != Entity.DATA_CATEGORY.INTEGRAL) {
            throw new RuntimeException("invalid column category type" + partitionColumn.getDataCategory().name() + ", expect Integral category.");
        }
        try {
            long longVal = partitionColumn.getNumber().longValue();
            int pos = this.lowerBound(this.ranges, Long.valueOf(longVal));
            if (0 <= pos && pos < this.ranges.length) {
                if (this.ranges[pos] == longVal) {
                    return this.locations.get(pos).get(0);
                }
                return this.locations.get(pos - 1).get(0);
            }
            throw new RuntimeException(partitionColumn.getNumber().longValue() + " not in partitioning range!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

