/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDateHour;
import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicDateHourMatrix
extends BasicIntMatrix {
    public BasicDateHourMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicDateHourMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicDateHourMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setDateHour(int row, int column, LocalDateTime value) {
        this.setInt(row, column, Utils.countHours(value));
    }

    public LocalDateTime getDateHour(int row, int column) {
        return Utils.parseDateHour(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDateHour(this.getInt(row, column));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDateHour.class;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATEHOUR;
    }
}

