/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicTime;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicTimeVector
extends BasicIntVector {
    public BasicTimeVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicTimeVector(List<Integer> list) {
        super(list);
    }

    public BasicTimeVector(int[] array) {
        super(array);
    }

    protected BasicTimeVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicTimeVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIME;
    }

    @Override
    public Scalar get(int index) {
        return new BasicTime(this.getInt(index));
    }

    public LocalTime getTime(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseTime(this.getInt(index));
    }

    public void setTime(int index, LocalTime time) {
        this.setInt(index, Utils.countMilliseconds(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicTime.class;
    }
}

