/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.DBConnection;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicInt;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.route.TableRouter;
import com.xxdb.route.TableRouterFacotry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PartitionedTableAppender {
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private Map<String, DBConnection> connectionMap = new HashMap<String, DBConnection>();
    private BasicDictionary tableInfo;
    private TableRouter router;
    private BasicString tableName;
    private int partitionColumnIdx;
    private int cols;
    private Entity.DATA_CATEGORY[] columnCategories;
    private Entity.DATA_TYPE[] columnTypes;
    private int threadCount;
    private ExecutorService threadPool;
    private static final BasicEntityFactory entityFactory = new BasicEntityFactory();
    private static final int CHECK_RESULT_SINGLE_ROW = 1;
    private static final int CHECK_RESULT_MULTI_ROWS = 2;

    public PartitionedTableAppender(String tableName, String host, int port) throws IOException {
        this(tableName, host, port, 0);
    }

    public PartitionedTableAppender(String tableName, String host, int port, int threadCount) throws IOException {
        BasicAnyVector locations;
        this.tableName = new BasicString(tableName);
        try (DBConnection conn = new DBConnection();){
            conn.connect(host, port);
            this.tableInfo = (BasicDictionary)conn.run("schema(" + tableName + ")");
            this.partitionColumnIdx = ((BasicInt)this.tableInfo.get(new BasicString("partitionColumnIndex"))).getInt();
            if (this.partitionColumnIdx == -1) {
                throw new RuntimeException("Table '" + tableName + "' is not partitioned");
            }
            locations = (BasicAnyVector)this.tableInfo.get(new BasicString("partitionSites"));
            int partitionType = ((BasicInt)this.tableInfo.get(new BasicString("partitionType"))).getInt();
            AbstractVector partitionSchema = (AbstractVector)this.tableInfo.get(new BasicString("partitionSchema"));
            this.router = TableRouterFacotry.createRouter(Entity.PARTITION_TYPE.values()[partitionType], partitionSchema, locations);
            BasicTable colDefs = (BasicTable)this.tableInfo.get(new BasicString("colDefs"));
            this.cols = colDefs.getColumn(0).rows();
            BasicIntVector typeInts = (BasicIntVector)colDefs.getColumn("typeInt");
            this.columnCategories = new Entity.DATA_CATEGORY[this.cols];
            this.columnTypes = new Entity.DATA_TYPE[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                this.columnTypes[i] = Entity.DATA_TYPE.values()[typeInts.getInt(i)];
                this.columnCategories[i] = Entity.typeToCategory(this.columnTypes[i]);
            }
        }
        this.threadCount = threadCount;
        if (this.threadCount <= 0) {
            this.threadCount = Math.min(CORES, locations.rows());
        }
        if (this.threadCount > 0) {
            --this.threadCount;
        }
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
    }

    private String getDestination(Scalar partitioningColumn) {
        return this.router.route(partitioningColumn);
    }

    private DBConnection getConnection(Entity partitioningColumn) throws IOException {
        if (!(partitioningColumn instanceof Scalar)) {
            throw new RuntimeException("partitioning column value must be a scalar");
        }
        String dest = this.getDestination((Scalar)partitioningColumn);
        DBConnection conn = this.connectionMap.get(dest);
        if (conn == null) {
            conn = new DBConnection();
            String[] destParts = dest.split(":");
            conn.connect(destParts[0], Integer.valueOf(destParts[1]));
            this.connectionMap.put(dest, conn);
        }
        return conn;
    }

    private int appendBatch(List<Entity> subTable) throws IOException {
        int i;
        if (subTable.get(0).rows() == 0) {
            return 0;
        }
        ArrayList<DBConnection> destConns = new ArrayList<DBConnection>();
        HashMap<DBConnection, BatchAppendTask> conn2TaskMap = new HashMap<DBConnection, BatchAppendTask>();
        AbstractVector partitioningColumnVector = (AbstractVector)subTable.get(this.partitionColumnIdx);
        int rows = partitioningColumnVector.rows();
        for (i = 0; i < rows; ++i) {
            DBConnection conn = this.getConnection(partitioningColumnVector.get(i));
            if (!conn2TaskMap.containsKey(conn)) {
                conn2TaskMap.put(conn, new BatchAppendTask(this.cols, conn));
            }
            destConns.add(conn);
        }
        for (i = 0; i < this.cols; ++i) {
            Set keySet = conn2TaskMap.keySet();
            for (DBConnection conn : keySet) {
                BatchAppendTask task = (BatchAppendTask)conn2TaskMap.get(conn);
                task.appendColumn();
            }
            AbstractVector column = (AbstractVector)subTable.get(i);
            for (int j = 0; j < rows; ++j) {
                DBConnection destConn = (DBConnection)destConns.get(j);
                BatchAppendTask destTask = (BatchAppendTask)conn2TaskMap.get(destConn);
                destTask.appendToLastColumn(column.get(j));
            }
        }
        int affected = 0;
        BatchAppendTask savedTask = null;
        Set keySet = conn2TaskMap.keySet();
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (DBConnection conn : keySet) {
            BatchAppendTask task = (BatchAppendTask)conn2TaskMap.get(conn);
            if (savedTask == null) {
                savedTask = task;
                continue;
            }
            futures.add(this.threadPool.submit(task));
        }
        affected += savedTask.call().intValue();
        for (int i2 = 0; i2 < futures.size(); ++i2) {
            try {
                affected += ((Integer)((Future)futures.get(i2)).get()).intValue();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return affected;
    }

    private int appendSingle(List<Entity> row) throws IOException {
        try (DBConnection conn = this.getConnection(row.get(this.partitionColumnIdx));){
            ArrayList<Entity> args = new ArrayList<Entity>();
            args.add(this.tableName);
            args.addAll(row);
            int n = ((BasicInt)conn.run("tableInsert", args)).getInt();
            return n;
        }
    }

    private void checkColumnType(int col, Entity.DATA_CATEGORY category, Entity.DATA_TYPE type) {
        Entity.DATA_CATEGORY expectCategory = this.columnCategories[col];
        Entity.DATA_TYPE expectType = this.columnTypes[col];
        if (category != expectCategory) {
            throw new RuntimeException("column " + col + ", expect category " + expectCategory.name() + ", got category " + category.name());
        }
        if (category == Entity.DATA_CATEGORY.TEMPORAL && type != expectType) {
            throw new RuntimeException("column " + col + ", temporal column must have exactly the same type, expect " + expectType.name() + ", got " + type.name());
        }
    }

    private int check(List<Entity> row) {
        int i;
        if (row.size() != this.cols) {
            throw new RuntimeException("expect " + this.cols + " columns of values, got " + row.size() + " columns of values");
        }
        for (i = 1; i < this.cols; ++i) {
            if (row.get(i).rows() == row.get(i - 1).rows()) continue;
            throw new RuntimeException("all columns must have the same size");
        }
        for (i = 0; i < this.cols; ++i) {
            this.checkColumnType(i, row.get(i).getDataCategory(), row.get(i).getDataType());
        }
        if (row.get(this.partitionColumnIdx) instanceof AbstractVector) {
            return 2;
        }
        return 1;
    }

    public int append(List<Entity> row) throws IOException {
        if (this.check(row) == 1) {
            return this.appendSingle(row);
        }
        return this.appendBatch(row);
    }

    public void shutdownThreadPool() {
        this.threadPool.shutdown();
    }

    private class BatchAppendTask
    implements Callable<Integer> {
        List<List<Scalar>> columns;
        DBConnection conn;

        BatchAppendTask(int cols, DBConnection conn) {
            this.columns = new ArrayList<List<Scalar>>(cols);
            this.conn = conn;
        }

        @Override
        public Integer call() {
            ArrayList<Entity> args = new ArrayList<Entity>(1 + this.columns.size());
            args.add(PartitionedTableAppender.this.tableName);
            for (int i = 0; i < this.columns.size(); ++i) {
                List<Scalar> column = this.columns.get(i);
                Vector vector = entityFactory.createVectorWithDefaultValue(column.get(0).getDataType(), column.size());
                for (int j = 0; j < column.size(); ++j) {
                    try {
                        vector.set(j, column.get(j));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                args.add(vector);
            }
            try {
                return ((BasicInt)this.conn.run("tableInsert", args)).getInt();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void appendColumn() {
            this.columns.add(new ArrayList());
        }

        public void appendToLastColumn(Scalar val) {
            this.columns.get(this.columns.size() - 1).add(val);
        }
    }
}

