/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.MessageDispatcher;
import com.xxdb.streaming.client.MessageParser;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

class Daemon
implements Runnable {
    private int listeningPort = 0;
    private MessageDispatcher dispatcher;
    private static final int KEEPALIVE_IDLE = 1000;
    private static final int KEEPALIVE_INTERVAL = 1000;
    private static final int KEEPALIVE_COUNT = 5;

    public Daemon(int port, MessageDispatcher dispatcher) {
        this.listeningPort = port;
        this.dispatcher = dispatcher;
    }

    @Override
    public void run() {
        ServerSocket ssocket = null;
        try {
            ssocket = new ServerSocket(this.listeningPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new Thread(new ReconnectDetector(this.dispatcher)).start();
        while (true) {
            try {
                while (true) {
                    Socket socket = ssocket.accept();
                    socket.setKeepAlive(true);
                    MessageParser listener = new MessageParser(socket, this.dispatcher);
                    Thread listeningThread = new Thread(listener);
                    listeningThread.start();
                    if (System.getProperty("os.name").equalsIgnoreCase("linux")) continue;
                    new Thread(new ConnectionDetector(socket)).start();
                }
            }
            catch (Exception ex) {}
            finally {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    class ConnectionDetector
    implements Runnable {
        Socket socket = null;

        public ConnectionDetector(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.socket.sendUrgentData(255);
                }
                catch (Exception ex) {
                    int failCount = 0;
                    for (int i = 0; i < 5; ++i) {
                        try {
                            this.socket.sendUrgentData(255);
                        }
                        catch (Exception ex0) {
                            ++failCount;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception ex1) {
                            ex.printStackTrace();
                        }
                    }
                    if (failCount != 5) continue;
                    try {
                        System.out.println("Connection closed!!");
                        this.socket.close();
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class ReconnectDetector
    implements Runnable {
        MessageDispatcher dispatcher = null;

        public ReconnectDetector(MessageDispatcher d) {
            this.dispatcher = d;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    for (String site : this.dispatcher.getAllReconnectSites()) {
                        if (this.dispatcher.getNeedReconnect(site) == 1) {
                            AbstractClient.Site s = this.dispatcher.getSiteByName(site);
                            this.dispatcher.activeCloseConnection(s);
                            String lastTopic = "";
                            for (String topic : this.dispatcher.getAllTopicsBySite(site)) {
                                System.out.println("try to reconnect topic " + topic);
                                this.dispatcher.tryReconnect(topic);
                                lastTopic = topic;
                            }
                            this.dispatcher.setNeedReconnect(lastTopic, 2);
                            continue;
                        }
                        long ts = this.dispatcher.getReconnectTimestamp(site);
                        if (System.currentTimeMillis() < ts + 3000L) continue;
                        AbstractClient.Site s = this.dispatcher.getSiteByName(site);
                        this.dispatcher.activeCloseConnection(s);
                        for (String topic : this.dispatcher.getAllTopicsBySite(site)) {
                            System.out.println("try to reconnect topic " + topic);
                            this.dispatcher.tryReconnect(topic);
                        }
                        this.dispatcher.setReconnectTimestamp(site, System.currentTimeMillis());
                    }
                    for (String topic : this.dispatcher.getAllReconnectTopic()) {
                        this.dispatcher.tryReconnect(topic);
                    }
                }
                catch (Exception e0) {
                    e0.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

