/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongMatrix;
import com.xxdb.data.BasicNanoTime;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicNanoTimeMatrix
extends BasicLongMatrix {
    public BasicNanoTimeMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicNanoTimeMatrix(int rows, int columns, List<long[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicNanoTimeMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setNanoTime(int row, int column, LocalTime value) {
        this.setLong(row, column, Utils.countNanoseconds(value));
    }

    public LocalTime getNanoTime(int row, int column) {
        return Utils.parseNanoTime(this.getLong(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicNanoTime(this.getLong(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIME;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicNanoTime.class;
    }
}

