/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicTimestamp
extends BasicLong {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy.MM.dd'T'HH:mm:ss.SSS");

    public BasicTimestamp(LocalDateTime value) {
        super(Utils.countMilliseconds(value));
    }

    public BasicTimestamp(ExtendedDataInput in) throws IOException {
        super(in);
    }

    protected BasicTimestamp(long value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIMESTAMP;
    }

    public LocalDateTime getTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseTimestamp(this.getLong());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getTimestamp();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getTimestamp().format(format);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicTimestamp) || o == null) {
            return false;
        }
        return this.getLong() == ((BasicTimestamp)o).getLong();
    }
}

