/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb;

import com.xxdb.DBConnection;
import com.xxdb.DBTask;
import com.xxdb.data.Entity;
import java.util.List;

public class BasicDBTask
implements DBTask {
    private String script;
    private List<Entity> args;
    private DBConnection conn;
    private Entity result = null;
    private String errMsg = null;
    private boolean successful = true;

    public BasicDBTask(String script, List<Entity> args) {
        this.script = script;
        this.args = args;
    }

    public BasicDBTask(String script) {
        this.script = script;
        this.args = null;
    }

    @Override
    public Entity call() {
        try {
            this.result = this.args != null ? this.conn.run(this.script, this.args) : this.conn.run(this.script);
            this.errMsg = null;
            this.successful = true;
            return this.result;
        }
        catch (Exception t) {
            this.successful = false;
            this.result = null;
            this.errMsg = t.getMessage();
            return null;
        }
    }

    @Override
    public void setDBConnection(DBConnection conn) {
        this.conn = conn;
    }

    @Override
    public Entity getResult() {
        return this.result;
    }

    @Override
    public String getErrorMsg() {
        return this.errMsg;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }
}

