/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.DeltaBitOutput;
import java.nio.ByteBuffer;

class DeltaOfDeltaBlockEncoder {
    private final int unitLength;
    private final int FIRST_DELTA_BITS;
    private ByteBuffer in;
    private DeltaBitOutput out;
    private long storedValue;
    private long storedDelta;
    private int count;

    DeltaOfDeltaBlockEncoder(int unitLength) {
        this.unitLength = unitLength;
        this.FIRST_DELTA_BITS = unitLength * 8;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public long[] compress(ByteBuffer src, int blockSize) {
        this.out = new DeltaBitOutput();
        this.in = src;
        this.count = 0;
        long value = 0L;
        while (this.count * this.unitLength < blockSize) {
            value = this.readBuffer(this.in);
            if (!(this.unitLength == 2 && value == -32768L || this.unitLength == 4 && value == Integer.MIN_VALUE || this.unitLength == 8 && value == Long.MIN_VALUE)) break;
            this.out.writeBits(0L, 1);
        }
        if (this.count * this.unitLength >= blockSize) {
            this.writeEnd();
            return this.out.getLongArray();
        }
        --this.count;
        this.in.position(this.in.position() - this.unitLength);
        this.writeHeader();
        while (this.count * this.unitLength < blockSize) {
            value = this.readBuffer(this.in);
            if (!(this.unitLength == 2 && value == -32768L || this.unitLength == 4 && value == Integer.MIN_VALUE || this.unitLength == 8 && value == Long.MIN_VALUE)) break;
            this.out.writeBits(0L, 1);
        }
        if (this.count * this.unitLength >= blockSize) {
            this.writeEnd();
            return this.out.getLongArray();
        }
        --this.count;
        this.in.position(this.in.position() - this.unitLength);
        this.writeFirstDelta();
        while (this.count * this.unitLength < blockSize) {
            try {
                this.writeNext();
            }
            catch (Exception ex) {
                // empty catch block
                break;
            }
        }
        this.writeEnd();
        return this.out.getLongArray();
    }

    private void writeHeader() {
        this.storedValue = this.readBuffer(this.in);
        this.out.writeBit();
        this.out.writeBits(DeltaOfDeltaBlockEncoder.encodeZigZag64(this.storedValue), this.unitLength * 8);
    }

    private void writeFirstDelta() {
        this.out.writeBit();
        long value = this.readBuffer(this.in);
        this.storedDelta = value - this.storedValue;
        this.out.writeBits(DeltaOfDeltaBlockEncoder.encodeZigZag64(this.storedDelta), this.FIRST_DELTA_BITS);
        this.storedValue = value;
    }

    private void writeNext() {
        long value = this.readBuffer(this.in);
        if (this.unitLength == 2 && value == -32768L || this.unitLength == 4 && value == Integer.MIN_VALUE || this.unitLength == 8 && value == Long.MIN_VALUE) {
            this.compressDataNull();
            return;
        }
        long newDelta = Math.subtractExact(value, this.storedValue);
        long deltaD = Math.subtractExact(newDelta, this.storedDelta);
        if (deltaD == 0L) {
            this.out.skipBit();
        } else {
            deltaD = DeltaOfDeltaBlockEncoder.encodeZigZag64(deltaD);
            if (--deltaD < 128L) {
                this.out.writeBits(2L, 2);
                this.out.writeBits(deltaD, 7);
            } else if (deltaD < 512L) {
                this.out.writeBits(6L, 3);
                this.out.writeBits(deltaD, 9);
            } else if (deltaD < 65536L) {
                this.out.writeBits(14L, 4);
                this.out.writeBits(deltaD, 16);
            } else if (deltaD < 0x100000000L) {
                this.out.writeBits(30L, 5);
                this.out.writeBits(deltaD, 32);
            } else {
                this.out.writeBits(62L, 6);
                this.out.writeBits(deltaD, 64);
            }
        }
        this.storedDelta = newDelta;
        this.storedValue = value;
    }

    public void compressDataNull() {
        this.out.writeBits(63L, 6);
    }

    public void writeEnd() {
        this.out.writeBits(62L, 6);
        this.out.writeBits(-1L, 64);
        this.out.skipBit();
    }

    private long readBuffer(ByteBuffer in) {
        ++this.count;
        if (this.unitLength == 2) {
            return in.getShort();
        }
        if (this.unitLength == 4) {
            return in.getInt();
        }
        if (this.unitLength == 8) {
            return in.getLong();
        }
        --this.count;
        throw new RuntimeException("Compression fails: can only support integral or temporal type");
    }
}

