/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.AbstractDecoder;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;

public class LZ4Decoder
extends AbstractDecoder {
    private LZ4SafeDecompressor decompressor = null;

    @Override
    public ExtendedDataInput decompress(DataInput in, int length, int unitLength, int elementCount, boolean isLittleEndian) throws IOException {
        if (this.decompressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.decompressor = factory.safeDecompressor();
        }
        int offset = 8;
        byte[] out = this.createColumnVector(elementCount, unitLength, isLittleEndian, 65536).array();
        while (length > 0) {
            int blockSize = in.readInt();
            if (blockSize < 0) {
                blockSize &= Integer.MAX_VALUE;
            }
            if ((blockSize = Math.min(blockSize, length -= 4)) == 0) break;
            byte[] src = new byte[blockSize];
            in.readFully(src);
            byte[] ret = this.decompressor.decompress(src, 65536);
            if (offset + ret.length > out.length) {
                out = Arrays.copyOf(out, out.length * 2);
            }
            System.arraycopy(ret, 0, out, offset, ret.length);
            offset += ret.length;
            length -= blockSize;
        }
        return isLittleEndian ? new LittleEndianDataInputStream(new ByteArrayInputStream(out, 0, offset)) : new BigEndianDataInputStream(new ByteArrayInputStream(out, 0, offset));
    }
}

