/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.compression;

import com.xxdb.compression.Encoder;
import com.xxdb.data.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class LZ4Encoder
implements Encoder {
    LZ4Compressor compressor;
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    @Override
    public List<Object> compress(ByteBuffer in, int elementCount, int unitLength, int maxCompressedLength, ByteBuffer out) throws IOException {
        if (this.compressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }
        int count = 0;
        while (in.limit() - in.position() > 0) {
            int blockSize = Math.min(65536, in.limit() - in.position());
            byte[] srcBytes = new byte[blockSize];
            in.get(srcBytes);
            byte[] destBuff = this.compressor.compress(srcBytes, 0, blockSize);
            int compressedLength = destBuff.length;
            while (destBuff.length + 4 + out.position() > out.capacity()) {
                out = Utils.reAllocByteBuffer(out, Math.max(65536, out.capacity() * 2));
            }
            out.putInt(compressedLength);
            out.put(destBuff, 0, compressedLength);
            count += 4 + compressedLength;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(count);
        ret.add(out);
        return ret;
    }

    public ByteBuffer compress(ByteBuffer in, int elementCount, int unitLength, int maxCompressedLength) throws IOException {
        int blockSize;
        int compressedLength;
        if (this.compressor == null) {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }
        ByteBuffer out = ByteBuffer.allocate(maxCompressedLength);
        for (int count = 0; elementCount > 0 && count < maxCompressedLength; count += compressedLength, elementCount -= blockSize / unitLength) {
            blockSize = Math.min(65536, elementCount * unitLength);
            byte[] src = new byte[blockSize];
            byte[] dest = new byte[blockSize];
            in.get(src);
            compressedLength = this.compressor.compress(src, 0, blockSize, dest, 0);
            out.putInt(compressedLength);
            out.put(dest, 0, compressedLength);
            count += 4;
        }
        out.flip();
        return out;
    }
}

